/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import jakarta.servlet.http.Cookie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class BufferedWebResponse
extends WebResponse
implements IMetaDataBufferingWebResponse {
    private final WebResponse originalResponse;
    private final List<Action> actions = new ArrayList<Action>();
    private StringBuilder charSequenceBuilder;
    private ByteArrayOutputStream dataStream;

    public BufferedWebResponse(WebResponse originalResponse) {
        if (originalResponse instanceof IMetaDataBufferingWebResponse) {
            ((IMetaDataBufferingWebResponse)((Object)originalResponse)).writeMetaData(this);
        }
        this.originalResponse = originalResponse;
    }

    @Override
    public void writeMetaData(WebResponse response) {
        for (Action action : this.actions) {
            if (action.getType() != ActionType.HEADER) continue;
            action.invoke(response);
        }
    }

    @Override
    public String encodeURL(CharSequence url) {
        if (this.originalResponse != null) {
            return this.originalResponse.encodeURL(url);
        }
        return url != null ? url.toString() : null;
    }

    @Override
    public String encodeRedirectURL(CharSequence url) {
        if (this.originalResponse != null) {
            return this.originalResponse.encodeRedirectURL(url);
        }
        return url != null ? url.toString() : null;
    }

    @Override
    public void reset() {
        super.reset();
        this.actions.clear();
        this.charSequenceBuilder = null;
        this.dataStream = null;
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.actions.add(ActionType.HEADER.action(res -> res.addCookie(cookie)));
    }

    @Override
    public void clearCookie(Cookie cookie) {
        this.actions.add(ActionType.HEADER.action(res -> res.clearCookie(cookie)));
    }

    @Override
    public void setContentLength(long length) {
        this.actions.add(ActionType.HEADER.action(res -> res.setContentLength(length)));
    }

    @Override
    public void setContentType(String mimeType) {
        this.actions.add(ActionType.HEADER.action(res -> res.setContentType(mimeType)));
    }

    @Override
    public void setDateHeader(String name, Instant date) {
        Args.notNull(date, "date");
        this.actions.add(ActionType.HEADER.action(res -> res.setDateHeader(name, date)));
    }

    @Override
    public boolean isHeaderSupported() {
        return this.originalResponse.isHeaderSupported();
    }

    @Override
    public void setHeader(String name, String value) {
        this.actions.add(ActionType.HEADER.action(res -> res.setHeader(name, value)));
    }

    @Override
    public void addHeader(String name, String value) {
        this.actions.add(ActionType.HEADER.action(res -> res.addHeader(name, value)));
    }

    @Override
    public void disableCaching() {
        this.actions.add(ActionType.HEADER.action(WebResponse::disableCaching));
    }

    @Override
    public void write(CharSequence sequence) {
        if (this.dataStream != null) {
            throw new IllegalStateException("Can't call write(CharSequence) after write(byte[]) has been called.");
        }
        if (this.charSequenceBuilder == null) {
            StringBuilder builder;
            this.charSequenceBuilder = builder = new StringBuilder(4096);
            this.actions.add(ActionType.DATA.action(res -> {
                AppendingStringBuffer responseBuffer = new AppendingStringBuffer(builder);
                List<IResponseFilter> responseFilters = Application.get().getRequestCycleSettings().getResponseFilters();
                if (responseFilters != null) {
                    for (IResponseFilter filter : responseFilters) {
                        responseBuffer = filter.filter(responseBuffer);
                    }
                }
                res.write(responseBuffer);
            }));
        }
        this.charSequenceBuilder.append(sequence);
    }

    public CharSequence getText() {
        if (this.dataStream != null) {
            throw new IllegalStateException("write(byte[]) has already been called.");
        }
        if (this.charSequenceBuilder != null) {
            return this.charSequenceBuilder;
        }
        return null;
    }

    public void setText(CharSequence text) {
        if (this.dataStream != null) {
            throw new IllegalStateException("write(byte[]) has already been called.");
        }
        if (this.charSequenceBuilder != null) {
            this.charSequenceBuilder.setLength(0);
        }
        this.write(text);
    }

    @Override
    public void write(byte[] array) {
        this.write(array, 0, array.length);
    }

    @Override
    public void write(byte[] array, int offset, int length) {
        if (this.charSequenceBuilder != null) {
            throw new IllegalStateException("Can't call write(byte[]) after write(CharSequence) has been called.");
        }
        if (this.dataStream == null) {
            ByteArrayOutputStream stream;
            this.dataStream = stream = new ByteArrayOutputStream();
            this.actions.add(ActionType.DATA.action(res -> BufferedWebResponse.writeStream(res, stream)));
        }
        this.dataStream.write(array, offset, length);
    }

    @Override
    public void sendRedirect(String url) {
        this.actions.add(ActionType.REDIRECT.action(res -> res.sendRedirect(url)));
    }

    @Override
    public void setStatus(int sc) {
        this.actions.add(ActionType.HEADER.action(res -> res.setStatus(sc)));
    }

    @Override
    public void sendError(int sc, String msg) {
        this.actions.add(ActionType.NORMAL.action(res -> res.sendError(sc, msg)));
    }

    public void writeTo(WebResponse response) {
        Args.notNull(response, "response");
        Collections.sort(this.actions);
        for (Action action : this.actions) {
            action.invoke(response);
        }
    }

    @Override
    public boolean isRedirect() {
        for (Action action : this.actions) {
            if (action.getType() != ActionType.REDIRECT) continue;
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.actions.add(ActionType.NORMAL.action(WebResponse::flush));
    }

    private static void writeStream(final Response response, ByteArrayOutputStream stream) {
        final boolean[] copied = new boolean[]{false};
        try {
            stream.writeTo(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    if (off == 0 && len == b.length) {
                        response.write(b);
                        copied[0] = true;
                    }
                }
            });
        }
        catch (IOException e1) {
            throw new WicketRuntimeException(e1);
        }
        if (!copied[0]) {
            response.write(stream.toByteArray());
        }
    }

    public String toString() {
        String toString = this.charSequenceBuilder != null ? this.charSequenceBuilder.toString() : super.toString();
        return toString;
    }

    @Override
    public Object getContainerResponse() {
        return this.originalResponse.getContainerResponse();
    }

    private static final class Action
    implements Comparable<Action> {
        private final ActionType type;
        private final Consumer<WebResponse> action;

        private Action(ActionType type, Consumer<WebResponse> action) {
            this.type = type;
            this.action = action;
        }

        protected final void invoke(WebResponse response) {
            this.action.accept(response);
        }

        protected final ActionType getType() {
            return this.type;
        }

        @Override
        public int compareTo(Action o) {
            return this.getType().ordinal() - o.getType().ordinal();
        }
    }

    private static enum ActionType {
        HEADER,
        REDIRECT,
        NORMAL,
        DATA;


        protected final Action action(Consumer<WebResponse> action) {
            return new Action(this, action);
        }
    }
}

