/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.AttributeMap;

public class JavaScriptUtils {
    public static final String SCRIPT_CONTENT_PREFIX = "\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CONTENT_SUFFIX = "\n/*]]>*/\n";
    public static final String SCRIPT_OPEN_TAG = "<script type=\"text/javascript\">\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CLOSE_TAG = "\n/*]]>*/\n</script>\n";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_SCRIPT_SRC = "src";
    public static final String ATTR_SCRIPT_DEFER = "defer";
    public static final String ATTR_SCRIPT_ASYNC = "async";
    public static final String ATTR_CSP_NONCE = "nonce";
    public static final String ATTR_CROSS_ORIGIN = "crossOrigin";
    public static final String ATTR_INTEGRITY = "integrity";

    public static CharSequence escapeQuotes(CharSequence input) {
        CharSequence s = input;
        if (s != null) {
            s = Strings.replaceAll(s, "'", "\\'");
            s = Strings.replaceAll(s, "\"", "\\\"");
        }
        return s;
    }

    public static void writeScript(Response response, AttributeMap attributes) {
        response.write("<script");
        response.write(attributes.toCharSequence());
        response.write("></script>");
        response.write("\n");
    }

    public static void writeInlineScript(Response response, CharSequence text, AttributeMap attributes) {
        JavaScriptUtils.writeOpenTag(response, attributes);
        response.write(Strings.replaceAll(text, "</", "<\\/"));
        JavaScriptUtils.writeCloseTag(response);
    }

    public static void writeJavaScript(Response response, CharSequence text) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_TYPE, "text/javascript");
        JavaScriptUtils.writeInlineScript(response, text, attributes);
    }

    public static void writeOpenTag(Response response, AttributeMap attributes) {
        response.write("<script");
        response.write(attributes.toCharSequence());
        response.write(">");
        response.write(SCRIPT_CONTENT_PREFIX);
    }

    public static void writeCloseTag(Response response) {
        response.write(SCRIPT_CONTENT_SUFFIX);
        response.write("</script>\n");
    }
}

