/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.value.AttributeMap;

public final class CssUtils {
    public static final String INLINE_OPEN_TAG_START = "<style type=\"text/css\"";
    public static final String INLINE_OPEN_TAG = "<style type=\"text/css\">\n";
    public static final String INLINE_CLOSE_TAG = "</style>\n";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_LINK_HREF = "href";
    public static final String ATTR_LINK_MEDIA = "media";
    public static final String ATTR_LINK_REL = "rel";
    public static final String ATTR_CSP_NONCE = "nonce";
    public static final String ATTR_CROSS_ORIGIN = "crossOrigin";
    public static final String ATTR_INTEGRITY = "integrity";

    private CssUtils() {
    }

    public static void writeInlineStyle(Response response, CharSequence text, AttributeMap attributes) {
        CssUtils.writeOpenTag(response, attributes);
        response.write(text);
        CssUtils.writeCloseTag(response);
    }

    public static void writeOpenTag(Response response, String id) {
        AttributeMap attributes = new AttributeMap();
        attributes.putAttribute(ATTR_ID, id);
        CssUtils.writeOpenTag(response, attributes);
    }

    public static void writeOpenTag(Response response, AttributeMap attributes) {
        response.write(INLINE_OPEN_TAG_START);
        response.write(attributes.toCharSequence());
        response.write(">\n");
    }

    public static void writeCloseTag(Response response) {
        response.write(INLINE_CLOSE_TAG);
    }

    public static void writeLink(Response response, AttributeMap attributes) {
        response.write("<link");
        response.write(attributes.toCharSequence());
        response.write(" />");
    }

    public static String key(Class<?> scope, String facet) {
        return Classes.simpleName(scope) + ".CSS." + facet;
    }
}

