/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.coep;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.wicket.coep.CrossOriginEmbedderPolicyConfiguration;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossOriginEmbedderPolicyRequestCycleListener
implements IRequestCycleListener {
    private static final Logger log = LoggerFactory.getLogger(CrossOriginEmbedderPolicyRequestCycleListener.class);
    static final String REQUIRE_CORP = "require-corp";
    private final CrossOriginEmbedderPolicyConfiguration coepConfig;

    public CrossOriginEmbedderPolicyRequestCycleListener(CrossOriginEmbedderPolicyConfiguration coepConfig) {
        this.coepConfig = Args.notNull(coepConfig, "coepConfig");
    }

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        this.protect(cycle, handler);
    }

    @Override
    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        this.protect(cycle, handler);
    }

    protected void protect(RequestCycle cycle, IRequestHandler handler) {
        Object containerRequest = cycle.getRequest().getContainerRequest();
        if (containerRequest instanceof HttpServletRequest) {
            WebResponse webResponse;
            HttpServletRequest request = (HttpServletRequest)containerRequest;
            String path = request.getContextPath();
            String coepHeaderName = this.coepConfig.getCoepHeader();
            if (this.coepConfig.getExemptions().contains(path)) {
                log.debug("Request path {} is exempted from COEP, no '{}' header added", (Object)path, (Object)coepHeaderName);
                return;
            }
            if (cycle.getResponse() instanceof WebResponse && (webResponse = (WebResponse)cycle.getResponse()).isHeaderSupported()) {
                webResponse.setHeader(coepHeaderName, REQUIRE_CORP);
            }
        }
    }
}

