/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.commons.fileupload2.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.wicket.commons.fileupload2.FileItemHeaders;
import org.apache.wicket.commons.fileupload2.FileItemStream;
import org.apache.wicket.commons.fileupload2.FileUploadException;
import org.apache.wicket.commons.fileupload2.MultipartStream;
import org.apache.wicket.commons.fileupload2.disk.DiskFileItem;
import org.apache.wicket.commons.fileupload2.impl.FileItemIteratorImpl;
import org.apache.wicket.commons.fileupload2.pub.FileUploadByteCountLimitException;
import org.apache.wicket.commons.fileupload2.util.LimitedInputStream;

public class FileItemStreamImpl
implements FileItemStream {
    private final FileItemIteratorImpl fileItemIteratorImpl;
    private final String contentType;
    private final String fieldName;
    private final String fileName;
    private final boolean formField;
    private final InputStream inputStream;
    private boolean inputStreamClosed;
    private FileItemHeaders headers;

    public FileItemStreamImpl(FileItemIteratorImpl fileItemIterator, final String fileName, final String fieldName, String contentType, boolean formField, long contentLength) throws FileUploadException, IOException {
        MultipartStream.ItemInputStream itemInputStream;
        this.fileItemIteratorImpl = fileItemIterator;
        this.fileName = fileName;
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.formField = formField;
        long fileSizeMax = this.fileItemIteratorImpl.getFileSizeMax();
        if (fileSizeMax != -1L && contentLength != -1L && contentLength > fileSizeMax) {
            throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", fieldName, fileSizeMax), contentLength, fileSizeMax, fileName, fieldName);
        }
        InputStream istream = itemInputStream = this.fileItemIteratorImpl.getMultiPartStream().newInputStream();
        if (fileSizeMax != -1L) {
            istream = new LimitedInputStream(istream, fileSizeMax){

                @Override
                protected void raiseError(long sizeMax, long count) throws IOException {
                    itemInputStream.close(true);
                    throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", fieldName, sizeMax), count, sizeMax, fileName, fieldName);
                }
            };
        }
        this.inputStream = istream;
    }

    public void close() throws IOException {
        this.inputStream.close();
        this.inputStreamClosed = true;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public InputStream openStream() throws IOException {
        if (this.inputStreamClosed) {
            throw new FileItemStream.ItemSkippedException();
        }
        return this.inputStream;
    }

    @Override
    public void setHeaders(FileItemHeaders headers) {
        this.headers = headers;
    }
}

