/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.commons.fileupload2;

import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.wicket.commons.fileupload2.RequestContext;

public abstract class AbstractRequestContext
implements RequestContext {
    private final LongSupplier contentLengthDefault;
    private final Function<String, String> contentLengthString;

    protected AbstractRequestContext(Function<String, String> contentLengthString, LongSupplier contentLengthDefault) {
        this.contentLengthString = contentLengthString;
        this.contentLengthDefault = contentLengthDefault;
    }

    @Override
    public long getContentLength() {
        try {
            return Long.parseLong(this.contentLengthString.apply("Content-length"));
        }
        catch (NumberFormatException e) {
            return this.contentLengthDefault.getAsLong();
        }
    }

    public String toString() {
        return String.format("%s [ContentLength=%s, ContentType=%s]", this.getClass().getSimpleName(), this.getContentLength(), this.getContentType());
    }
}

