/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.IResourceFactory;
import org.apache.wicket.Localizer;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.caching.CachingResourceStreamLocator;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.markup.head.PriorityFirstComparator;
import org.apache.wicket.markup.head.ResourceAggregator;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.SecurePackageResourceGuard;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.caching.FilenameWithVersionResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.NoOpResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.version.CachingResourceVersion;
import org.apache.wicket.request.resource.caching.version.IResourceVersion;
import org.apache.wicket.request.resource.caching.version.LastModifiedResourceVersion;
import org.apache.wicket.request.resource.caching.version.MessageDigestResourceVersion;
import org.apache.wicket.request.resource.caching.version.RequestCycleCachedResourceVersion;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.IPropertiesFactoryContext;
import org.apache.wicket.resource.PropertiesFactory;
import org.apache.wicket.resource.loader.ClassStringResourceLoader;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.resource.loader.InitializerStringResourceLoader;
import org.apache.wicket.resource.loader.PackageStringResourceLoader;
import org.apache.wicket.resource.loader.ValidatorStringResourceLoader;
import org.apache.wicket.util.file.IFileCleaner;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.apache.wicket.util.watch.ModificationWatcher;

public class ResourceSettings
implements IPropertiesFactoryContext {
    private Localizer localizer;
    private final Map<String, IResourceFactory> nameToResourceFactory = Generics.newHashMap();
    private IPackageResourceGuard packageResourceGuard = new SecurePackageResourceGuard(new SecurePackageResourceGuard.SimpleCache(100));
    private IPropertiesFactory propertiesFactory;
    private List<IResourceFinder> resourceFinders = new ArrayList<IResourceFinder>();
    private Duration resourcePollFrequency = null;
    private IResourceStreamLocator resourceStreamLocator;
    private IModificationWatcher resourceWatcher;
    private IFileCleaner fileCleaner;
    private final List<IStringResourceLoader> stringResourceLoaders = Generics.newArrayList(6);
    private boolean throwExceptionOnMissingResource = true;
    private boolean useDefaultOnMissingResource = true;
    private Duration defaultCacheDuration = WebResponse.MAX_CACHE_DURATION;
    private IJavaScriptCompressor javascriptCompressor;
    private ICssCompressor cssCompressor;
    private String parentFolderPlaceholder = "::";
    private IResourceCachingStrategy resourceCachingStrategy;
    private final Application application;
    private boolean useMinifiedResources = true;
    private Comparator<? super ResourceAggregator.RecordedHeaderItem> headerItemComparator = new PriorityFirstComparator(false);
    private boolean encodeJSessionId = false;

    public ResourceSettings(Application application) {
        this.application = application;
        this.stringResourceLoaders.add(new ComponentStringResourceLoader());
        this.stringResourceLoaders.add(new PackageStringResourceLoader());
        this.stringResourceLoaders.add(new ClassStringResourceLoader(application.getClass()));
        this.stringResourceLoaders.add(new ValidatorStringResourceLoader());
        this.stringResourceLoaders.add(new InitializerStringResourceLoader(application.getInitializers()));
    }

    public ResourceSettings addResourceFactory(String name, IResourceFactory resourceFactory) {
        this.nameToResourceFactory.put(name, resourceFactory);
        return this;
    }

    @Override
    public Localizer getLocalizer() {
        if (this.localizer == null) {
            this.localizer = new Localizer();
        }
        return this.localizer;
    }

    public IPackageResourceGuard getPackageResourceGuard() {
        return this.packageResourceGuard;
    }

    public IPropertiesFactory getPropertiesFactory() {
        if (this.propertiesFactory == null) {
            this.propertiesFactory = new PropertiesFactory(this);
        }
        return this.propertiesFactory;
    }

    public IResourceFactory getResourceFactory(String name) {
        return this.nameToResourceFactory.get(name);
    }

    public List<IResourceFinder> getResourceFinders() {
        return this.resourceFinders;
    }

    public Duration getResourcePollFrequency() {
        return this.resourcePollFrequency;
    }

    @Override
    public IResourceStreamLocator getResourceStreamLocator() {
        if (this.resourceStreamLocator == null) {
            this.resourceStreamLocator = new ResourceStreamLocator(this.getResourceFinders());
            this.resourceStreamLocator = new CachingResourceStreamLocator(this.resourceStreamLocator);
        }
        return this.resourceStreamLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IModificationWatcher getResourceWatcher(boolean start) {
        if (this.resourceWatcher == null && start) {
            ResourceSettings resourceSettings = this;
            synchronized (resourceSettings) {
                Duration pollFrequency;
                if (this.resourceWatcher == null && (pollFrequency = this.getResourcePollFrequency()) != null) {
                    this.resourceWatcher = new ModificationWatcher(pollFrequency);
                }
            }
        }
        return this.resourceWatcher;
    }

    public ResourceSettings setResourceWatcher(IModificationWatcher watcher) {
        this.resourceWatcher = watcher;
        return this;
    }

    public IFileCleaner getFileCleaner() {
        return this.fileCleaner;
    }

    public ResourceSettings setFileCleaner(IFileCleaner fileUploadCleaner) {
        this.fileCleaner = fileUploadCleaner;
        return this;
    }

    public List<IStringResourceLoader> getStringResourceLoaders() {
        return this.stringResourceLoaders;
    }

    public boolean getThrowExceptionOnMissingResource() {
        return this.throwExceptionOnMissingResource;
    }

    public boolean getUseDefaultOnMissingResource() {
        return this.useDefaultOnMissingResource;
    }

    public ResourceSettings setLocalizer(Localizer localizer) {
        this.localizer = localizer;
        return this;
    }

    public ResourceSettings setPackageResourceGuard(IPackageResourceGuard packageResourceGuard) {
        this.packageResourceGuard = Args.notNull(packageResourceGuard, "packageResourceGuard");
        return this;
    }

    public ResourceSettings setPropertiesFactory(IPropertiesFactory factory) {
        this.propertiesFactory = factory;
        return this;
    }

    public ResourceSettings setResourceFinders(List<IResourceFinder> resourceFinders) {
        Args.notNull(resourceFinders, "resourceFinders");
        this.resourceFinders = resourceFinders;
        this.resourceStreamLocator = null;
        return this;
    }

    public ResourceSettings setResourcePollFrequency(Duration resourcePollFrequency) {
        this.resourcePollFrequency = resourcePollFrequency;
        return this;
    }

    public ResourceSettings setResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        this.resourceStreamLocator = resourceStreamLocator;
        return this;
    }

    public ResourceSettings setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.throwExceptionOnMissingResource = throwExceptionOnMissingResource;
        return this;
    }

    public ResourceSettings setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.useDefaultOnMissingResource = useDefaultOnMissingResource;
        return this;
    }

    public final Duration getDefaultCacheDuration() {
        return this.defaultCacheDuration;
    }

    public final ResourceSettings setDefaultCacheDuration(Duration duration) {
        Args.notNull(duration, "duration");
        this.defaultCacheDuration = duration;
        return this;
    }

    public IJavaScriptCompressor getJavaScriptCompressor() {
        return this.javascriptCompressor;
    }

    public IJavaScriptCompressor setJavaScriptCompressor(IJavaScriptCompressor compressor) {
        IJavaScriptCompressor old = this.javascriptCompressor;
        this.javascriptCompressor = compressor;
        return old;
    }

    public ICssCompressor getCssCompressor() {
        return this.cssCompressor;
    }

    public ICssCompressor setCssCompressor(ICssCompressor compressor) {
        ICssCompressor old = this.cssCompressor;
        this.cssCompressor = compressor;
        return old;
    }

    public String getParentFolderPlaceholder() {
        return this.parentFolderPlaceholder;
    }

    public ResourceSettings setParentFolderPlaceholder(String sequence) {
        this.parentFolderPlaceholder = sequence;
        return this;
    }

    public IResourceCachingStrategy getCachingStrategy() {
        if (this.resourceCachingStrategy == null) {
            IResourceVersion resourceVersion = this.application.usesDevelopmentConfig() ? new RequestCycleCachedResourceVersion(new LastModifiedResourceVersion()) : new CachingResourceVersion(new MessageDigestResourceVersion());
            this.resourceCachingStrategy = new FilenameWithVersionResourceCachingStrategy(resourceVersion);
        }
        return this.resourceCachingStrategy;
    }

    public ResourceSettings setCachingStrategy(IResourceCachingStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("It is not allowed to set the resource caching strategy to value NULL. Please use " + NoOpResourceCachingStrategy.class.getName() + " instead.");
        }
        this.resourceCachingStrategy = strategy;
        return this;
    }

    public ResourceSettings setUseMinifiedResources(boolean useMinifiedResources) {
        this.useMinifiedResources = useMinifiedResources;
        return this;
    }

    public boolean getUseMinifiedResources() {
        return this.useMinifiedResources;
    }

    public Comparator<? super ResourceAggregator.RecordedHeaderItem> getHeaderItemComparator() {
        return this.headerItemComparator;
    }

    public ResourceSettings setHeaderItemComparator(Comparator<? super ResourceAggregator.RecordedHeaderItem> headerItemComparator) {
        this.headerItemComparator = headerItemComparator;
        return this;
    }

    public boolean isEncodeJSessionId() {
        return this.encodeJSessionId;
    }

    public ResourceSettings setEncodeJSessionId(boolean encodeJSessionId) {
        this.encodeJSessionId = encodeJSessionId;
        return this;
    }
}

