/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.commons.fileupload2.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.commons.fileupload2.AbstractFileUpload;
import org.apache.wicket.commons.fileupload2.FileItem;
import org.apache.wicket.commons.fileupload2.FileItemHeaders;
import org.apache.wicket.commons.fileupload2.FileItemIterator;
import org.apache.wicket.commons.fileupload2.FileItemStream;
import org.apache.wicket.commons.fileupload2.FileUploadException;
import org.apache.wicket.commons.fileupload2.MultipartStream;
import org.apache.wicket.commons.fileupload2.RequestContext;
import org.apache.wicket.commons.fileupload2.impl.FileItemStreamImpl;
import org.apache.wicket.commons.fileupload2.pub.FileUploadContentTypeException;
import org.apache.wicket.commons.fileupload2.pub.FileUploadSizeException;
import org.apache.wicket.commons.fileupload2.util.LimitedInputStream;

public class FileItemIteratorImpl
implements FileItemIterator {
    private final AbstractFileUpload fileUploadBase;
    private final RequestContext ctx;
    private long sizeMax;
    private long fileSizeMax;
    private MultipartStream multiPartStream;
    private MultipartStream.ProgressNotifier progressNotifier;
    private byte[] multiPartBoundary;
    private FileItemStreamImpl currentItem;
    private String currentFieldName;
    private boolean skipPreamble;
    private boolean itemValid;
    private boolean eof;

    public FileItemIteratorImpl(AbstractFileUpload fileUploadBase, RequestContext requestContext) throws FileUploadException, IOException {
        this.fileUploadBase = fileUploadBase;
        this.sizeMax = fileUploadBase.getSizeMax();
        this.fileSizeMax = fileUploadBase.getFileSizeMax();
        this.ctx = Objects.requireNonNull(requestContext, "requestContext");
        this.skipPreamble = true;
        this.findNextItem();
    }

    private boolean findNextItem() throws FileUploadException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.currentItem != null) {
            this.currentItem.close();
            this.currentItem = null;
        }
        MultipartStream multi = this.getMultiPartStream();
        while (true) {
            boolean nextPart;
            if (!(nextPart = this.skipPreamble ? multi.skipPreamble() : multi.readBoundary())) {
                if (this.currentFieldName == null) {
                    this.eof = true;
                    return false;
                }
                multi.setBoundary(this.multiPartBoundary);
                this.currentFieldName = null;
                continue;
            }
            FileItemHeaders headers = this.fileUploadBase.getParsedHeaders(multi.readHeaders());
            if (this.currentFieldName == null) {
                String fieldName = this.fileUploadBase.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = headers.getHeader("Content-type");
                    if (subContentType != null && subContentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/mixed")) {
                        this.currentFieldName = fieldName;
                        byte[] subBoundary = this.fileUploadBase.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        this.skipPreamble = true;
                        continue;
                    }
                    String fileName = this.fileUploadBase.getFileName(headers);
                    this.currentItem = new FileItemStreamImpl(this, fileName, fieldName, headers.getHeader("Content-type"), fileName == null, this.getContentLength(headers));
                    this.currentItem.setHeaders(headers);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            } else {
                String fileName = this.fileUploadBase.getFileName(headers);
                if (fileName != null) {
                    this.currentItem = new FileItemStreamImpl(this, fileName, this.currentFieldName, headers.getHeader("Content-type"), false, this.getContentLength(headers));
                    this.currentItem.setHeaders(headers);
                    this.progressNotifier.noteItem();
                    this.itemValid = true;
                    return true;
                }
            }
            multi.discardBodyData();
        }
    }

    private long getContentLength(FileItemHeaders headers) {
        try {
            return Long.parseLong(headers.getHeader("Content-length"));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public List<FileItem> getFileItems() throws FileUploadException, IOException {
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        while (this.hasNext()) {
            FileItemStream fis = this.next();
            items.add(this.fileUploadBase.getFileItemFactory().createItem(fis.getFieldName(), fis.getContentType(), fis.isFormField(), fis.getName()));
        }
        return items;
    }

    @Override
    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public MultipartStream getMultiPartStream() throws FileUploadException, IOException {
        if (this.multiPartStream == null) {
            this.init(this.fileUploadBase, this.ctx);
        }
        return this.multiPartStream;
    }

    @Override
    public long getSizeMax() {
        return this.sizeMax;
    }

    @Override
    public boolean hasNext() throws FileUploadException, IOException {
        if (this.eof) {
            return false;
        }
        if (this.itemValid) {
            return true;
        }
        return this.findNextItem();
    }

    protected void init(AbstractFileUpload fileUploadBase, RequestContext requestContext) throws FileUploadException, IOException {
        InputStream input;
        long requestSize;
        String contentType = this.ctx.getContentType();
        if (null == contentType || !contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/")) {
            throw new FileUploadContentTypeException(String.format("the request doesn't contain a %s or %s stream, content type header is %s", "multipart/form-data", "multipart/mixed", contentType), contentType);
        }
        long contentLengthInt = this.ctx.getContentLength();
        long l = requestSize = RequestContext.class.isAssignableFrom(this.ctx.getClass()) ? this.ctx.getContentLength() : contentLengthInt;
        if (this.sizeMax >= 0L) {
            if (requestSize != -1L && requestSize > this.sizeMax) {
                throw new FileUploadSizeException(String.format("the request was rejected because its size (%s) exceeds the configured maximum (%s)", requestSize, this.sizeMax), this.sizeMax, requestSize);
            }
            input = new LimitedInputStream(this.ctx.getInputStream(), this.sizeMax){

                @Override
                protected void raiseError(long maxLen, long count) throws IOException {
                    throw new FileUploadSizeException(String.format("The request was rejected because its size (%s) exceeds the configured maximum (%s)", count, maxLen), maxLen, count);
                }
            };
        } else {
            input = this.ctx.getInputStream();
        }
        String charEncoding = fileUploadBase.getHeaderEncoding();
        if (charEncoding == null) {
            charEncoding = this.ctx.getCharacterEncoding();
        }
        this.multiPartBoundary = fileUploadBase.getBoundary(contentType);
        if (this.multiPartBoundary == null) {
            IOUtils.closeQuietly(input);
            throw new FileUploadException("the request was rejected because no multipart boundary was found");
        }
        this.progressNotifier = new MultipartStream.ProgressNotifier(fileUploadBase.getProgressListener(), requestSize);
        try {
            this.multiPartStream = new MultipartStream(input, this.multiPartBoundary, this.progressNotifier);
        }
        catch (IllegalArgumentException e) {
            IOUtils.closeQuietly(input);
            throw new FileUploadContentTypeException(String.format("The boundary specified in the %s header is too long", "Content-type"), e);
        }
        this.multiPartStream.setHeaderEncoding(charEncoding);
    }

    @Override
    public FileItemStream next() throws FileUploadException, IOException {
        if (this.eof || !this.itemValid && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.itemValid = false;
        return this.currentItem;
    }

    @Override
    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    @Override
    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }
}

