/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.commons.fileupload2.disk;

import java.io.File;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.wicket.commons.fileupload2.FileItem;
import org.apache.wicket.commons.fileupload2.FileItemFactory;
import org.apache.wicket.commons.fileupload2.disk.DiskFileItem;

public class DiskFileItemFactory
implements FileItemFactory {
    public static final int DEFAULT_SIZE_THRESHOLD = 10240;
    private File repository;
    private int sizeThreshold = 10240;
    private FileCleaningTracker fileCleaningTracker;
    private String defaultCharset = DiskFileItem.DEFAULT_CHARSET;

    public DiskFileItemFactory() {
        this(10240, null);
    }

    public DiskFileItemFactory(int sizeThreshold, File repository) {
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
    }

    @Override
    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        DiskFileItem result = new DiskFileItem(fieldName, contentType, isFormField, fileName, this.sizeThreshold, this.repository);
        result.setDefaultCharset(this.defaultCharset);
        FileCleaningTracker tracker = this.getFileCleaningTracker();
        if (tracker != null) {
            tracker.track(result.getTempFile(), (Object)result);
        }
        return result;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public FileCleaningTracker getFileCleaningTracker() {
        return this.fileCleaningTracker;
    }

    public File getRepository() {
        return this.repository;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setDefaultCharset(String charset) {
        this.defaultCharset = charset;
    }

    public void setFileCleaningTracker(FileCleaningTracker tracker) {
        this.fileCleaningTracker = tracker;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }
}

