/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.commons.fileupload2.FileItem;
import org.apache.wicket.commons.fileupload2.FileItemHeaders;
import org.apache.wicket.commons.fileupload2.util.FileItemHeadersImpl;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

class ServletPartFileItem
implements FileItem {
    private final Part part;
    private final boolean isFormField;

    ServletPartFileItem(Part part) {
        Args.notNull((Object)part, (String)"part");
        this.part = part;
        String contentType = part.getContentType();
        this.isFormField = contentType == null;
    }

    public InputStream getInputStream() throws IOException {
        return this.part.getInputStream();
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public String getName() {
        return this.getFileName(this.part);
    }

    private String getFileName(Part part) {
        String contentDisposition = part.getHeader("content-disposition");
        for (String cd : Strings.split((String)contentDisposition, (char)';')) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    public boolean isInMemory() {
        return true;
    }

    public long getSize() {
        return this.part.getSize();
    }

    public byte[] get() {
        try {
            return IOUtils.toByteArray((InputStream)this.getInputStream());
        }
        catch (IOException iox) {
            throw new WicketRuntimeException("Could not read upload's part input stream", iox);
        }
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        byte[] bytes = this.get();
        return new String(bytes, encoding);
    }

    public String getString() {
        try {
            return this.getString("UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            throw new WicketRuntimeException("UTF-8 must be supported", uex);
        }
    }

    public void write(File file) throws IOException {
        this.part.write(file.getName());
    }

    public void delete() {
        try {
            this.part.delete();
        }
        catch (IOException iox) {
            throw new WicketRuntimeException("A problem occurred while deleting an upload part", iox);
        }
    }

    public String getFieldName() {
        return this.part.getName();
    }

    public void setFieldName(String name) {
        throw new UnsupportedOperationException("setFieldName");
    }

    public boolean isFormField() {
        return this.isFormField;
    }

    public void setFormField(boolean state) {
        throw new UnsupportedOperationException("setFormField");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("getOutputStream");
    }

    public FileItemHeaders getHeaders() {
        FileItemHeadersImpl fileItemHeaders = new FileItemHeadersImpl();
        for (String headerName : this.part.getHeaderNames()) {
            Collection headerValues = this.part.getHeaders(headerName);
            for (String headerValue : headerValues) {
                fileItemHeaders.addHeader(headerName, headerValue);
            }
        }
        return fileItemHeaders;
    }

    public void setHeaders(FileItemHeaders headers) {
        throw new UnsupportedOperationException("setHeaders");
    }
}

