/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi.aggregate;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;

public class DateAggregate
extends BaseAggregate {
    private static final String DEFAULT_INTERVAL = "1M";
    private String interval;
    private String format;
    private static final Map<String, String> OLD_TO_NEW_FORMAT = Map.ofEntries(Map.entry("1s", "Second"), Map.entry("1m", "Minute"), Map.entry("1h", "Hour"), Map.entry("1d", "Day"), Map.entry("1w", "Week"), Map.entry("1M", "Month"), Map.entry("1q", "Quarter"), Map.entry("1y", "Year"));
    private static final Map<String, String> NEW_TO_OLD_FORMAT = DateAggregate.createReverseMap();

    private static Map<String, String> createReverseMap() {
        HashMap<String, String> reverseMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : OLD_TO_NEW_FORMAT.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(reverseMap);
    }

    public DateAggregate(String field) {
        super(field);
        this.interval = DEFAULT_INTERVAL;
    }

    public DateAggregate(String field, String interval) {
        super(field);
        this.setInterval(interval);
    }

    public DateAggregate(String field, String interval, String format) {
        super(field);
        this.setInterval(interval);
        this.format = format;
    }

    public void setInterval(String interval) {
        this.interval = interval != null && !interval.isEmpty() ? interval : DEFAULT_INTERVAL;
    }

    public String getInterval() {
        return this.interval;
    }

    public String getIntervalInOldFormat() {
        if (this.isOldFormat(this.interval)) {
            return this.interval;
        }
        return NEW_TO_OLD_FORMAT.getOrDefault(this.interval, this.interval);
    }

    public String getIntervalInNewFormat() {
        if (this.isNewFormat(this.interval)) {
            return this.interval;
        }
        return OLD_TO_NEW_FORMAT.getOrDefault(this.interval, this.interval);
    }

    @Deprecated
    public String getIntervalByAlias(String alias) {
        if (this.isOldFormat(alias)) {
            return OLD_TO_NEW_FORMAT.getOrDefault(alias, alias);
        }
        return alias;
    }

    public boolean isOldFormat(String value) {
        return OLD_TO_NEW_FORMAT.containsKey(value);
    }

    public boolean isNewFormat(String value) {
        return NEW_TO_OLD_FORMAT.containsKey(value);
    }

    public static String convertToNewFormat(String oldFormat) {
        return OLD_TO_NEW_FORMAT.getOrDefault(oldFormat, oldFormat);
    }

    public static String convertToOldFormat(String newFormat) {
        return NEW_TO_OLD_FORMAT.getOrDefault(newFormat, newFormat);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

