/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http.optional;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.TransportingException;
import groovyx.net.http.util.IoUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Download {
    private static final String ID = "LdazOKMfPTGymyyz5eLb/djgY3A=";

    public static void toTempFile(HttpConfig config) {
        Download.toTempFile(config, ContentTypes.ANY.getAt(0));
    }

    public static void toTempFile(HttpConfig config, String contentType) {
        try {
            Download.toFile(config, contentType, File.createTempFile("tmp", ".tmp"));
        }
        catch (IOException ioe) {
            throw new TransportingException(ioe);
        }
    }

    public static void toFile(HttpConfig config, File file) {
        Download.toFile(config, ContentTypes.ANY.getAt(0), file);
    }

    public static void toFile(HttpConfig config, String contentType, File file) {
        config.context(contentType, (Object)ID, (Object)file);
        config.getResponse().parser(contentType, Download::fileParser);
    }

    public static void toStream(HttpConfig config, OutputStream ostream) {
        Download.toStream(config, ContentTypes.ANY.getAt(0), ostream);
    }

    public static void toStream(HttpConfig config, String contentType, OutputStream ostream) {
        config.context(contentType, (Object)ID, (Object)ostream);
        config.getResponse().parser(contentType, Download::streamParser);
    }

    private static File fileParser(ChainedHttpConfig config, FromServer fs) {
        try {
            File file = (File)config.actualContext(fs.getContentType(), ID);
            IoUtils.transfer(fs.getInputStream(), new FileOutputStream(file), true);
            return file;
        }
        catch (IOException e) {
            throw new TransportingException(e);
        }
    }

    private static OutputStream streamParser(ChainedHttpConfig config, FromServer fs) {
        OutputStream ostream = (OutputStream)config.actualContext(fs.getContentType(), ID);
        IoUtils.transfer(fs.getInputStream(), ostream, false);
        return ostream;
    }
}

