/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.internal.osgi;

import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventHandlerRegistry;
import org.apache.karaf.cellar.core.event.EventHandlerServiceRegistry;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(provides={@ProvideService(value=EventHandlerRegistry.class)})
public class Activator
extends BaseActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private ServiceTracker<EventHandler, EventHandler> eventHandlerServiceTracker;

    @Override
    public void doStart() throws Exception {
        LOGGER.debug("CELLAR CORE: register event handler service registry");
        final EventHandlerServiceRegistry registry = new EventHandlerServiceRegistry();
        this.register(EventHandlerRegistry.class, registry);
        LOGGER.debug("CELLAR CORE: starting event handler service tracker");
        this.eventHandlerServiceTracker = new ServiceTracker(this.bundleContext, EventHandler.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<EventHandler, EventHandler>(){

            public EventHandler addingService(ServiceReference<EventHandler> serviceReference) {
                EventHandler eventHandler = (EventHandler)Activator.this.bundleContext.getService(serviceReference);
                registry.bind(eventHandler);
                return eventHandler;
            }

            public void modifiedService(ServiceReference<EventHandler> serviceReference, EventHandler eventHandler) {
            }

            public void removedService(ServiceReference<EventHandler> serviceReference, EventHandler eventHandler) {
                registry.unbind(eventHandler);
                Activator.this.bundleContext.ungetService(serviceReference);
            }
        });
        this.eventHandlerServiceTracker.open();
    }

    @Override
    public void doStop() {
        super.doStop();
        if (this.eventHandlerServiceTracker != null) {
            this.eventHandlerServiceTracker.close();
            this.eventHandlerServiceTracker = null;
        }
    }
}

