/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ModuleRef;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.InputStreamOrByteBufferAdapter;

public abstract class Resource
implements Closeable,
Comparable<Resource> {
    protected InputStream inputStream;
    protected ByteBuffer byteBuffer;
    protected long length = -1L;
    protected boolean isOpen;
    private String toString;

    protected InputStream byteBufferToInputStream() {
        return this.inputStream == null ? (this.inputStream = FileUtils.byteBufferToInputStream(this.byteBuffer)) : this.inputStream;
    }

    protected ByteBuffer inputStreamToByteBuffer() throws IOException {
        return this.byteBuffer == null ? (this.byteBuffer = ByteBuffer.wrap(this.inputStreamToByteArray())) : this.byteBuffer;
    }

    protected byte[] inputStreamToByteArray() throws IOException {
        return FileUtils.readAllBytesAsArray(this.inputStream, this.length);
    }

    protected byte[] byteBufferToByteArray() {
        if (this.byteBuffer.hasArray()) {
            return this.byteBuffer.array();
        }
        byte[] byteArray = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.get(byteArray);
        return byteArray;
    }

    protected void markAsOpen() throws IOException {
        if (this.isOpen) {
            throw new IOException("Resource is already open -- cannot open it again without first calling close()");
        }
        this.isOpen = true;
    }

    protected void markAsClosed() {
        this.isOpen = false;
    }

    public abstract String getPath();

    public abstract String getPathRelativeToClasspathElement();

    public abstract URL getURL();

    public abstract URL getClasspathElementURL();

    public abstract File getClasspathElementFile();

    public abstract ModuleRef getModuleRef();

    public abstract InputStream open() throws IOException;

    public abstract ByteBuffer read() throws IOException;

    public abstract byte[] load() throws IOException;

    abstract InputStreamOrByteBufferAdapter openOrRead() throws IOException;

    public long getLength() {
        return this.length;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        this.toString = this.getURL().toString();
        return this.toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Resource)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    @Override
    public int compareTo(Resource o) {
        return this.toString().compareTo(o.toString());
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                if (this.inputStream instanceof InputStreamResourceCloser) {
                    ((InputStreamResourceCloser)this.inputStream).closeInputStream();
                } else {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
    }

    protected class InputStreamResourceCloser
    extends InputStream {
        private InputStream inputStream;
        private Resource parentResource;

        protected InputStreamResourceCloser(Resource parentResource, InputStream inputStream) throws IOException {
            if (inputStream == null) {
                throw new IOException("InputStream cannot be null");
            }
            this.inputStream = inputStream;
            this.parentResource = parentResource;
        }

        @Override
        public int read() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.read(b);
        }

        @Override
        public int available() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.available();
        }

        @Override
        public long skip(long n) throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            return this.inputStream.skip(n);
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            if (this.inputStream == null) {
                throw new IOException("InputStream is not open");
            }
            this.inputStream.reset();
        }

        void closeInputStream() throws IOException {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.inputStream = null;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.parentResource != null) {
                try {
                    this.parentResource.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.parentResource = null;
            }
        }
    }
}

