/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.impl.action.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.runtime.Token;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.impl.action.command.HelpOption;
import org.apache.karaf.shell.support.CommandException;
import org.apache.karaf.shell.support.NameScoping;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.apache.karaf.shell.support.converter.DefaultConverter;
import org.apache.karaf.shell.support.converter.GenericType;

public class DefaultActionPreparator {
    public boolean prepare(Action action, Session session, List<Object> params) throws Exception {
        Command command = action.getClass().getAnnotation(Command.class);
        HashMap<Option, Field> options = new HashMap<Option, Field>();
        HashMap<Argument, Field> arguments = new HashMap<Argument, Field>();
        ArrayList<Argument> orderedArguments = new ArrayList<Argument>();
        for (Class<?> type = action.getClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    options.put(option, field);
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                Argument argument2 = this.replaceDefaultArgument(field, argument);
                arguments.put(argument2, field);
                int index = argument2.index();
                while (orderedArguments.size() <= index) {
                    orderedArguments.add(null);
                }
                if (orderedArguments.get(index) != null) {
                    throw new IllegalArgumentException("Duplicate argument index: " + index + " on Action " + action.getClass().getName());
                }
                orderedArguments.set(index, argument2);
            }
        }
        this.assertIndexesAreCorrect(action.getClass(), orderedArguments);
        String commandErrorSt = SimpleAnsi.COLOR_RED + "Error executing command " + command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL + SimpleAnsi.COLOR_DEFAULT + ": ";
        for (Object e : params) {
            if (!HelpOption.HELP.name().equals(e.toString())) continue;
            int termWidth = session.getTerminal() != null ? session.getTerminal().getWidth() : 80;
            termWidth = termWidth == 0 ? 80 : termWidth;
            boolean globalScope = NameScoping.isGlobalScope(session, command.scope());
            this.printUsage(action, options, arguments, System.out, globalScope, termWidth);
            return false;
        }
        HashMap<Option, Object> optionValues = new HashMap<Option, Object>();
        HashMap<Argument, Object> hashMap = new HashMap<Argument, Object>();
        boolean processOptions = true;
        int argIndex = 0;
        Iterator<Object> it = params.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            String paramValue = null;
            if (object instanceof String) {
                paramValue = (String)object;
            }
            if (object instanceof Token) {
                paramValue = object.toString();
            }
            if (processOptions && paramValue != null && paramValue.startsWith("-")) {
                String name;
                boolean isKeyValuePair = paramValue.indexOf(61) != -1;
                Object value = null;
                if (isKeyValuePair) {
                    name = paramValue.substring(0, paramValue.indexOf(61));
                    value = paramValue.substring(paramValue.indexOf(61) + 1);
                } else {
                    name = paramValue;
                }
                Option option = null;
                for (Option opt : options.keySet()) {
                    if (!name.equals(opt.name()) && !Arrays.asList(opt.aliases()).contains(name)) continue;
                    option = opt;
                    break;
                }
                if (option == null) {
                    throw new CommandException(commandErrorSt + "undefined option " + SimpleAnsi.INTENSITY_BOLD + paramValue + SimpleAnsi.INTENSITY_NORMAL + "\nTry <command> --help' for more information.", "Undefined option: " + paramValue);
                }
                Field field = (Field)options.get(option);
                if (value == null && (field.getType() == Boolean.TYPE || field.getType() == Boolean.class)) {
                    value = Boolean.TRUE;
                }
                if (value == null && it.hasNext()) {
                    value = it.next();
                }
                if (value == null) {
                    throw new CommandException(commandErrorSt + "missing value for option " + SimpleAnsi.INTENSITY_BOLD + paramValue + SimpleAnsi.INTENSITY_NORMAL, "Missing value for option: " + paramValue);
                }
                if (option.multiValued()) {
                    ArrayList<Object> l = (ArrayList<Object>)optionValues.get(option);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        optionValues.put(option, l);
                    }
                    l.add(value);
                    continue;
                }
                optionValues.put(option, value);
                continue;
            }
            processOptions = false;
            if (argIndex >= orderedArguments.size()) {
                throw new CommandException(commandErrorSt + "too many arguments specified", "Too many arguments specified");
            }
            Argument argument = (Argument)orderedArguments.get(argIndex);
            if (!argument.multiValued()) {
                ++argIndex;
            }
            if (argument.multiValued()) {
                ArrayList<Object> l = (ArrayList<Object>)hashMap.get(argument);
                if (l == null) {
                    l = new ArrayList<Object>();
                    hashMap.put(argument, l);
                }
                l.add(object);
                continue;
            }
            hashMap.put(argument, object);
        }
        for (Option option : options.keySet()) {
            if (!option.required() || optionValues.get(option) != null) continue;
            throw new CommandException(commandErrorSt + "option " + SimpleAnsi.INTENSITY_BOLD + option.name() + SimpleAnsi.INTENSITY_NORMAL + " is required", "Option " + option.name() + " is required");
        }
        for (Argument argument : orderedArguments) {
            if (!argument.required() || hashMap.get(argument) != null) continue;
            throw new CommandException(commandErrorSt + "argument " + SimpleAnsi.INTENSITY_BOLD + argument.name() + SimpleAnsi.INTENSITY_NORMAL + " is required", "Argument " + argument.name() + " is required");
        }
        for (Map.Entry entry : optionValues.entrySet()) {
            Object value;
            Field field = (Field)options.get(entry.getKey());
            try {
                value = this.convert(action, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                throw new CommandException(commandErrorSt + "unable to convert option " + SimpleAnsi.INTENSITY_BOLD + ((Option)entry.getKey()).name() + SimpleAnsi.INTENSITY_NORMAL + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), "Unable to convert option " + ((Option)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
            }
            field.setAccessible(true);
            field.set(action, value);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Object value;
            Field field = (Field)arguments.get(entry.getKey());
            try {
                value = this.convert(action, entry.getValue(), field.getGenericType());
            }
            catch (Exception e) {
                throw new CommandException(commandErrorSt + "unable to convert argument " + SimpleAnsi.INTENSITY_BOLD + ((Argument)entry.getKey()).name() + SimpleAnsi.INTENSITY_NORMAL + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), "Unable to convert argument " + ((Argument)entry.getKey()).name() + " with value '" + entry.getValue() + "' to type " + new GenericType(field.getGenericType()).toString(), e);
            }
            field.setAccessible(true);
            field.set(action, value);
        }
        return true;
    }

    protected Object convert(Action action, Object value, Type toType) throws Exception {
        if (toType == String.class) {
            return value != null ? value.toString() : null;
        }
        return new DefaultConverter(action.getClass().getClassLoader()).convert(value, toType);
    }

    private Argument replaceDefaultArgument(Field field, Argument argument) {
        if ("##default".equals(argument.name())) {
            final Argument delegate = argument;
            final String name = field.getName();
            argument = new Argument(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String description() {
                    return delegate.description();
                }

                @Override
                public boolean required() {
                    return delegate.required();
                }

                @Override
                public int index() {
                    return delegate.index();
                }

                @Override
                public boolean multiValued() {
                    return delegate.multiValued();
                }

                @Override
                public String valueToShowInHelp() {
                    return delegate.valueToShowInHelp();
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return delegate.annotationType();
                }

                @Override
                public boolean censor() {
                    return delegate.censor();
                }

                @Override
                public char mask() {
                    return delegate.mask();
                }
            };
        }
        return argument;
    }

    private void assertIndexesAreCorrect(Class<? extends Action> actionClass, List<Argument> orderedArguments) {
        for (int i = 0; i < orderedArguments.size(); ++i) {
            if (orderedArguments.get(i) != null) continue;
            throw new IllegalArgumentException("Missing argument for index: " + i + " on Action " + actionClass.getName());
        }
    }

    public void printUsage(Action action, Map<Option, Field> options, Map<Argument, Field> arguments, PrintStream out, boolean globalScope, int termWidth) {
        Command command = action.getClass().getAnnotation(Command.class);
        if (command != null) {
            ArrayList<Argument> argumentsSet = new ArrayList<Argument>(arguments.keySet());
            argumentsSet.sort(Comparator.comparing(Argument::index));
            HashSet<Option> optionsSet = new HashSet<Option>(options.keySet());
            optionsSet.add(HelpOption.HELP);
            if (command != null && (command.description() != null || command.name() != null)) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DESCRIPTION" + SimpleAnsi.INTENSITY_NORMAL);
                out.print("        ");
                if (command.name() != null) {
                    if (globalScope) {
                        out.println(SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    } else {
                        out.println(command.scope() + ":" + SimpleAnsi.INTENSITY_BOLD + command.name() + SimpleAnsi.INTENSITY_NORMAL);
                    }
                    out.println();
                }
                out.print("\t");
                out.println(command.description());
                out.println();
            }
            StringBuilder syntax = new StringBuilder();
            if (command != null) {
                if (globalScope) {
                    syntax.append(command.name());
                } else {
                    syntax.append(String.format("%s:%s", command.scope(), command.name()));
                }
            }
            if (options.size() > 0) {
                syntax.append(" [options]");
            }
            if (arguments.size() > 0) {
                syntax.append(' ');
                for (Argument argument : argumentsSet) {
                    if (!argument.required()) {
                        syntax.append(String.format("[%s] ", argument.name()));
                        continue;
                    }
                    syntax.append(String.format("%s ", argument.name()));
                }
            }
            out.println(SimpleAnsi.INTENSITY_BOLD + "SYNTAX" + SimpleAnsi.INTENSITY_NORMAL);
            out.print("        ");
            out.println(syntax.toString());
            out.println();
            if (arguments.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "ARGUMENTS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Argument argument : argumentsSet) {
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + argument.name() + SimpleAnsi.INTENSITY_NORMAL);
                    DefaultActionPreparator.printFormatted("                ", argument.description(), termWidth, out, true);
                    if (!argument.required()) {
                        if (argument.valueToShowInHelp() == null || argument.valueToShowInHelp().length() == 0) continue;
                        if ("DEFAULT".equals(argument.valueToShowInHelp())) {
                            Object o = this.getDefaultValue(action, arguments.get(argument));
                            String string = this.getDefaultValueString(o);
                            if (string == null) continue;
                            this.printDefaultsTo(out, string);
                            continue;
                        }
                        this.printDefaultsTo(out, argument.valueToShowInHelp());
                        continue;
                    }
                    this.printMeta(out, argument.required(), argument.multiValued());
                }
                out.println();
            }
            if (options.size() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "OPTIONS" + SimpleAnsi.INTENSITY_NORMAL);
                for (Option option : optionsSet) {
                    String opt = option.name();
                    for (String alias : option.aliases()) {
                        opt = opt + ", " + alias;
                    }
                    out.print("        ");
                    out.println(SimpleAnsi.INTENSITY_BOLD + opt + SimpleAnsi.INTENSITY_NORMAL);
                    DefaultActionPreparator.printFormatted("                ", option.description(), termWidth, out, true);
                    if (option.valueToShowInHelp() != null && option.valueToShowInHelp().length() != 0) {
                        if ("DEFAULT".equals(option.valueToShowInHelp())) {
                            Object object = this.getDefaultValue(action, options.get(option));
                            String defaultValue = this.getDefaultValueString(object);
                            if (defaultValue != null) {
                                this.printDefaultsTo(out, defaultValue);
                                continue;
                            }
                            this.printMeta(out, option.required(), option.multiValued());
                            continue;
                        }
                        this.printDefaultsTo(out, option.valueToShowInHelp());
                        continue;
                    }
                    this.printMeta(out, option.required(), option.multiValued());
                }
                out.println();
            }
            if (command.detailedDescription().length() > 0) {
                out.println(SimpleAnsi.INTENSITY_BOLD + "DETAILS" + SimpleAnsi.INTENSITY_NORMAL);
                String desc = this.loadDescription(action.getClass(), command.detailedDescription());
                DefaultActionPreparator.printFormatted("        ", desc, termWidth, out, true);
            }
        }
    }

    public Object getDefaultValue(Action action, Field field) {
        if (field != null) {
            try {
                field.setAccessible(true);
                return field.get(action);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private String loadDescription(Class<?> clazz, String desc) {
        if (desc != null && desc.startsWith("classpath:")) {
            desc = this.loadClassPathResource(clazz, desc.substring("classpath:".length()));
        }
        return desc;
    }

    public String getDefaultValueString(Object o) {
        if (!(o == null || o instanceof Boolean && !((Boolean)o).booleanValue() || o instanceof Number && ((Number)o).doubleValue() == 0.0)) {
            return o.toString();
        }
        return null;
    }

    private void printDefaultsTo(PrintStream out, String value) {
        out.println("                (defaults to " + value + ")");
    }

    private void printMeta(PrintStream out, boolean required, boolean multivalued) {
        if (required || multivalued) {
            String text = "                (";
            if (required) {
                text = text + "required";
                if (multivalued) {
                    text = text + ", ";
                }
            }
            if (multivalued) {
                text = text + "multi-valued";
            }
            text = text + ")";
            out.println(text);
        }
    }

    static void printFormatted(String prefix, String str, int termWidth, PrintStream out, boolean prefixFirstLine) {
        int pfxLen = prefix.length();
        int maxwidth = termWidth - pfxLen;
        Pattern wrap = Pattern.compile("(\\S\\S{" + maxwidth + ",}|.{1," + maxwidth + "})(\\s+|$)");
        int cur = 0;
        while (cur >= 0) {
            String s;
            int lst = str.indexOf(10, cur);
            String string = s = lst >= 0 ? str.substring(cur, lst) : str.substring(cur);
            if (s.length() == 0) {
                out.println();
            } else {
                Matcher m = wrap.matcher(s);
                while (m.find()) {
                    if (cur > 0 || prefixFirstLine) {
                        out.print(prefix);
                    }
                    out.println(m.group());
                }
            }
            if (lst < 0) break;
            cur = lst + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadClassPathResource(Class<?> clazz, String path) {
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            is = clazz.getClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            return "Unable to load description from " + path;
        }
        try {
            int c;
            InputStreamReader r = new InputStreamReader(is);
            StringWriter sw = new StringWriter();
            while ((c = ((Reader)r).read()) != -1) {
                sw.append((char)c);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            String string = "Unable to load description from " + path;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }
}

