/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.events;

import inet.ipaddr.Address;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.EventProperty;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.ActionPostExecutor;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventListenerService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.apache.unomi.services.impl.ParserHelper;
import org.apache.unomi.services.impl.events.ThirdPartyServer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceImpl
implements EventService {
    private static final Logger logger = LoggerFactory.getLogger((String)EventServiceImpl.class.getName());
    private static final int MAX_RECURSION_DEPTH = 10;
    private List<EventListenerService> eventListeners = new CopyOnWriteArrayList<EventListenerService>();
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private BundleContext bundleContext;
    private Set<String> predefinedEventTypeIds = new LinkedHashSet<String>();
    private Set<String> restrictedEventTypeIds = new LinkedHashSet<String>();
    private Map<String, ThirdPartyServer> thirdPartyServers = new HashMap<String, ThirdPartyServer>();

    public void init() {
        logger.info("Event service initialized.");
    }

    public void destroy() {
        logger.info("Event service shutdown.");
    }

    public void setThirdPartyConfiguration(Map<String, String> thirdPartyConfiguration) {
        this.thirdPartyServers = new HashMap<String, ThirdPartyServer>();
        for (Map.Entry<String, String> entry : thirdPartyConfiguration.entrySet()) {
            String[] keys = StringUtils.split((String)entry.getKey(), (char)'.');
            if (!keys[0].equals("thirdparty")) continue;
            if (!this.thirdPartyServers.containsKey(keys[1])) {
                this.thirdPartyServers.put(keys[1], new ThirdPartyServer(keys[1]));
            }
            ThirdPartyServer thirdPartyServer = this.thirdPartyServers.get(keys[1]);
            if (keys[2].equals("allowedEvents")) {
                HashSet<String> allowedEvents = new HashSet<String>(Arrays.asList(StringUtils.split((String)entry.getValue(), (char)',')));
                this.restrictedEventTypeIds.addAll(allowedEvents);
                thirdPartyServer.setAllowedEvents(allowedEvents);
                continue;
            }
            if (keys[2].equals("key")) {
                thirdPartyServer.setKey(entry.getValue());
                continue;
            }
            if (!keys[2].equals("ipAddresses")) continue;
            HashSet<IPAddress> ipAddresses = new HashSet<IPAddress>();
            for (String ip : StringUtils.split((String)entry.getValue(), (char)',')) {
                IPAddress ipAddress = new IPAddressString(ip.trim()).getAddress();
                ipAddresses.add(ipAddress);
            }
            thirdPartyServer.setIpAddresses(ipAddresses);
        }
    }

    public void setPredefinedEventTypeIds(Set<String> predefinedEventTypeIds) {
        this.predefinedEventTypeIds = predefinedEventTypeIds;
    }

    public void setRestrictedEventTypeIds(Set<String> restrictedEventTypeIds) {
        this.restrictedEventTypeIds = restrictedEventTypeIds;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isEventAllowed(Event event, String thirdPartyId) {
        if (this.restrictedEventTypeIds.contains(event.getEventType())) {
            return this.thirdPartyServers.containsKey(thirdPartyId) && this.thirdPartyServers.get(thirdPartyId).getAllowedEvents().contains(event.getEventType());
        }
        return true;
    }

    public String authenticateThirdPartyServer(String key, String ip) {
        logger.debug("Authenticating third party server with key: " + key + " and IP: " + ip);
        if (key != null) {
            for (Map.Entry<String, ThirdPartyServer> entry : this.thirdPartyServers.entrySet()) {
                ThirdPartyServer server = entry.getValue();
                if (!server.getKey().equals(key)) continue;
                IPAddress ipAddress = new IPAddressString(ip).getAddress();
                for (IPAddress serverIpAddress : server.getIpAddresses()) {
                    if (!serverIpAddress.contains((Address)ipAddress)) continue;
                    return server.getId();
                }
            }
            logger.warn("Could not authenticate any third party servers for key: {}", (Object)key);
        }
        return null;
    }

    public int send(Event event) {
        return this.send(event, 0);
    }

    private int send(Event event, int depth) {
        int changes;
        if (depth > 10) {
            logger.warn("Max recursion depth reached");
            return 0;
        }
        boolean saveSucceeded = true;
        if (event.isPersistent()) {
            saveSucceeded = this.persistenceService.save((Item)event, null, Boolean.valueOf(true));
        }
        if (saveSucceeded) {
            changes = 0;
            Session session = event.getSession();
            if (event.isPersistent() && session != null) {
                session.setLastEventDate(event.getTimeStamp());
            }
            if (event.getProfile() != null) {
                for (EventListenerService eventListenerService : this.eventListeners) {
                    if (!eventListenerService.canHandle(event)) continue;
                    changes |= eventListenerService.onEvent(event);
                }
                for (ActionPostExecutor actionPostExecutor : event.getActionPostExecutors()) {
                    changes |= actionPostExecutor.execute() ? changes : 0;
                }
                if ((changes & 4) == 4) {
                    Event profileUpdated = new Event("profileUpdated", session, event.getProfile(), event.getScope(), event.getSource(), (Item)event.getProfile(), event.getTimeStamp());
                    profileUpdated.setPersistent(false);
                    profileUpdated.getAttributes().putAll(event.getAttributes());
                    changes |= this.send(profileUpdated, depth + 1);
                    if (session != null && session.getProfileId() != null) {
                        changes |= 2;
                        session.setProfile(event.getProfile());
                    }
                }
            }
        } else {
            changes = 1;
        }
        return changes;
    }

    public List<EventProperty> getEventProperties() {
        Map mappings = this.persistenceService.getPropertiesMapping("event");
        ArrayList<EventProperty> props = new ArrayList<EventProperty>(mappings.size());
        this.getEventProperties(mappings, props, "");
        return props;
    }

    private void getEventProperties(Map<String, Map<String, Object>> mappings, List<EventProperty> props, String prefix) {
        for (Map.Entry<String, Map<String, Object>> e : mappings.entrySet()) {
            if (e.getValue().get("properties") != null) {
                this.getEventProperties((Map)e.getValue().get("properties"), props, prefix + e.getKey() + ".");
                continue;
            }
            props.add(new EventProperty(prefix + e.getKey(), (String)e.getValue().get("type")));
        }
    }

    public Set<String> getEventTypeIds() {
        Map dynamicEventTypeIds = this.persistenceService.aggregateWithOptimizedQuery(null, (BaseAggregate)new TermsAggregate("eventType"), "event");
        LinkedHashSet<String> eventTypeIds = new LinkedHashSet<String>(this.predefinedEventTypeIds);
        eventTypeIds.addAll(dynamicEventTypeIds.keySet());
        return eventTypeIds;
    }

    public PartialList<Event> searchEvents(Condition condition, int offset, int size) {
        ParserHelper.resolveConditionType(this.definitionsService, condition, "event search");
        return this.persistenceService.query(condition, "timeStamp", Event.class, offset, size);
    }

    public PartialList<Event> searchEvents(String sessionId, String[] eventTypes, String query, int offset, int size, String sortBy) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Condition condition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        condition.setParameter("propertyName", (Object)"sessionId");
        condition.setParameter("propertyValue", (Object)sessionId);
        condition.setParameter("comparisonOperator", (Object)"equals");
        conditions.add(condition);
        condition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        condition.setParameter("operator", (Object)"or");
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        for (String eventType : eventTypes) {
            Condition subCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
            subCondition.setParameter("propertyName", (Object)"eventType");
            subCondition.setParameter("propertyValue", (Object)eventType);
            subCondition.setParameter("comparisonOperator", (Object)"equals");
            subConditions.add(subCondition);
        }
        condition.setParameter("subConditions", subConditions);
        conditions.add(condition);
        condition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        condition.setParameter("operator", (Object)"and");
        condition.setParameter("subConditions", conditions);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            return this.persistenceService.queryFullText(query, condition, sortBy, Event.class, offset, size);
        }
        return this.persistenceService.query(condition, sortBy, Event.class, offset, size);
    }

    public PartialList<Event> search(Query query) {
        if (query.getScrollIdentifier() != null) {
            return this.persistenceService.continueScrollQuery(Event.class, query.getScrollIdentifier(), query.getScrollTimeValidity());
        }
        if (query.getCondition() != null && this.definitionsService.resolveConditionType(query.getCondition())) {
            if (StringUtils.isNotBlank((CharSequence)query.getText())) {
                return this.persistenceService.queryFullText(query.getText(), query.getCondition(), query.getSortby(), Event.class, query.getOffset(), query.getLimit());
            }
            return this.persistenceService.query(query.getCondition(), query.getSortby(), Event.class, query.getOffset(), query.getLimit(), query.getScrollTimeValidity());
        }
        if (StringUtils.isNotBlank((CharSequence)query.getText())) {
            return this.persistenceService.queryFullText(query.getText(), query.getSortby(), Event.class, query.getOffset(), query.getLimit());
        }
        return this.persistenceService.getAllItems(Event.class, query.getOffset(), query.getLimit(), query.getSortby());
    }

    public Event getEvent(String id) {
        return (Event)this.persistenceService.load(id, Event.class);
    }

    public boolean hasEventAlreadyBeenRaised(Event event) {
        Event pastEvent = (Event)this.persistenceService.load(event.getItemId(), Event.class);
        return pastEvent != null && pastEvent.getVersion() >= 1L && (pastEvent.getSessionId() != null && pastEvent.getSessionId().equals(event.getSessionId()) || pastEvent.getProfileId() != null && pastEvent.getProfileId().equals(event.getProfileId()));
    }

    public boolean hasEventAlreadyBeenRaised(Event event, boolean session) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Condition profileIdCondition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        if (session) {
            profileIdCondition.setParameter("propertyName", (Object)"sessionId");
            profileIdCondition.setParameter("propertyValue", (Object)event.getSessionId());
        } else {
            profileIdCondition.setParameter("propertyName", (Object)"profileId");
            profileIdCondition.setParameter("propertyValue", (Object)event.getProfileId());
        }
        profileIdCondition.setParameter("comparisonOperator", (Object)"equals");
        conditions.add(profileIdCondition);
        Condition condition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        condition.setParameter("propertyName", (Object)"eventType");
        condition.setParameter("propertyValue", (Object)event.getEventType());
        condition.setParameter("comparisonOperator", (Object)"equals");
        conditions.add(condition);
        condition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        condition.setParameter("propertyName", (Object)"target.itemId");
        condition.setParameter("propertyValue", (Object)event.getTarget().getItemId());
        condition.setParameter("comparisonOperator", (Object)"equals");
        conditions.add(condition);
        condition = new Condition(this.definitionsService.getConditionType("eventPropertyCondition"));
        condition.setParameter("propertyName", (Object)"target.itemType");
        condition.setParameter("propertyValue", (Object)event.getTarget().getItemType());
        condition.setParameter("comparisonOperator", (Object)"equals");
        conditions.add(condition);
        Condition andCondition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", conditions);
        long size = this.persistenceService.queryCount(andCondition, "event");
        return size > 0L;
    }

    public void bind(ServiceReference<EventListenerService> serviceReference) {
        EventListenerService eventListenerService = (EventListenerService)this.bundleContext.getService(serviceReference);
        this.eventListeners.add(eventListenerService);
    }

    public void unbind(ServiceReference<EventListenerService> serviceReference) {
        if (serviceReference != null) {
            EventListenerService eventListenerService = (EventListenerService)this.bundleContext.getService(serviceReference);
            this.eventListeners.remove(eventListenerService);
        }
    }

    public void removeProfileEvents(String profileId) {
        Condition profileCondition = new Condition();
        profileCondition.setConditionType(this.definitionsService.getConditionType("eventPropertyCondition"));
        profileCondition.setParameter("propertyName", (Object)"profileId");
        profileCondition.setParameter("comparisonOperator", (Object)"equals");
        profileCondition.setParameter("propertyValue", (Object)profileId);
        this.persistenceService.removeByQuery(profileCondition, Event.class);
    }
}

