/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features.internal.osgi;

import java.util.Hashtable;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.features.FeaturesEventHandler;
import org.apache.karaf.cellar.features.FeaturesSynchronizer;
import org.apache.karaf.cellar.features.LocalFeaturesListener;
import org.apache.karaf.cellar.features.RepositoryEventHandler;
import org.apache.karaf.cellar.features.management.CellarFeaturesMBean;
import org.apache.karaf.cellar.features.management.internal.CellarFeaturesMBeanImpl;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(provides={@ProvideService(value=FeaturesListener.class), @ProvideService(value=Synchronizer.class), @ProvideService(value=EventHandler.class), @ProvideService(value=CellarFeaturesMBean.class)}, requires={@RequireService(value=ClusterManager.class), @RequireService(value=GroupManager.class), @RequireService(value=EventProducer.class), @RequireService(value=ConfigurationAdmin.class), @RequireService(value=FeaturesService.class)})
public class Activator
extends BaseActivator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private LocalFeaturesListener localFeaturesListener;
    private FeaturesSynchronizer featuresSynchronizer;
    private FeaturesEventHandler featuresEventHandler;
    private RepositoryEventHandler repositoryEventHandler;
    private ServiceRegistration mbeanRegistration;

    @Override
    public void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        ClusterManager clusterManager = this.getTrackedService(ClusterManager.class);
        if (clusterManager == null) {
            return;
        }
        GroupManager groupManager = this.getTrackedService(GroupManager.class);
        if (groupManager == null) {
            return;
        }
        EventProducer eventProducer = this.getTrackedService(EventProducer.class);
        if (eventProducer == null) {
            return;
        }
        FeaturesService featuresService = this.getTrackedService(FeaturesService.class);
        if (featuresService == null) {
            return;
        }
        LOGGER.debug("CELLAR FEATURE: init repository event handler");
        this.repositoryEventHandler = new RepositoryEventHandler();
        this.repositoryEventHandler.setConfigurationAdmin(configurationAdmin);
        this.repositoryEventHandler.setFeaturesService(featuresService);
        this.repositoryEventHandler.setClusterManager(clusterManager);
        this.repositoryEventHandler.setGroupManager(groupManager);
        this.repositoryEventHandler.init(this.bundleContext);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("managed", "true");
        this.register(new Class[]{EventHandler.class}, (Object)this.repositoryEventHandler, props);
        LOGGER.debug("CELLAR FEATURE: init features event handler");
        this.featuresEventHandler = new FeaturesEventHandler();
        this.featuresEventHandler.setFeaturesService(featuresService);
        this.featuresEventHandler.setClusterManager(clusterManager);
        this.featuresEventHandler.setGroupManager(groupManager);
        this.featuresEventHandler.setConfigurationAdmin(configurationAdmin);
        this.featuresEventHandler.init(this.bundleContext);
        this.register(new Class[]{EventHandler.class}, (Object)this.featuresEventHandler, props);
        LOGGER.debug("CELLAR FEATURE: init local features listener");
        this.localFeaturesListener = new LocalFeaturesListener();
        this.localFeaturesListener.setClusterManager(clusterManager);
        this.localFeaturesListener.setGroupManager(groupManager);
        this.localFeaturesListener.setEventProducer(eventProducer);
        this.localFeaturesListener.setConfigurationAdmin(configurationAdmin);
        this.localFeaturesListener.setFeaturesService(featuresService);
        this.localFeaturesListener.init(this.bundleContext);
        this.register(FeaturesListener.class, this.localFeaturesListener);
        LOGGER.debug("CELLAR FEATURE: init features synchronizer");
        this.featuresSynchronizer = new FeaturesSynchronizer();
        this.featuresSynchronizer.setClusterManager(clusterManager);
        this.featuresSynchronizer.setGroupManager(groupManager);
        this.featuresSynchronizer.setEventProducer(eventProducer);
        this.featuresSynchronizer.setConfigurationAdmin(configurationAdmin);
        this.featuresSynchronizer.setFeaturesService(featuresService);
        this.featuresSynchronizer.init(this.bundleContext);
        props = new Hashtable();
        props.put("resource", "feature");
        this.register(Synchronizer.class, this.featuresSynchronizer, props);
        LOGGER.debug("CELLAR FEATURE: register MBean");
        CellarFeaturesMBeanImpl mbean = new CellarFeaturesMBeanImpl();
        mbean.setClusterManager(clusterManager);
        mbean.setGroupManager(groupManager);
        mbean.setConfigurationAdmin(configurationAdmin);
        mbean.setFeaturesService(featuresService);
        mbean.setEventProducer(eventProducer);
        props = new Hashtable();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=feature,name=" + System.getProperty("karaf.name"));
        this.mbeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(mbean), (Object)mbean, props);
    }

    @Override
    public void doStop() {
        super.doStop();
        if (this.mbeanRegistration != null) {
            this.mbeanRegistration.unregister();
            this.mbeanRegistration = null;
        }
        if (this.featuresSynchronizer != null) {
            this.featuresSynchronizer.destroy();
            this.featuresSynchronizer = null;
        }
        if (this.localFeaturesListener != null) {
            this.localFeaturesListener.destroy();
            this.localFeaturesListener = null;
        }
        if (this.featuresEventHandler != null) {
            this.featuresEventHandler.destroy();
            this.featuresEventHandler = null;
        }
        if (this.repositoryEventHandler != null) {
            this.repositoryEventHandler.destroy();
            this.repositoryEventHandler = null;
        }
    }
}

