/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.Result;
import org.apache.karaf.cellar.core.control.BasicSwitch;
import org.apache.karaf.cellar.core.control.Switch;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicProducer<E extends Event>
implements EventProducer<E> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(TopicProducer.class);
    public static final String SWITCH_ID = "org.apache.karaf.cellar.topic.producer";
    private final Switch eventSwitch = new BasicSwitch("org.apache.karaf.cellar.topic.producer");
    private HazelcastInstance instance;
    private ITopic topic;
    private Node node;
    private ConfigurationAdmin configurationAdmin;

    public void init() {
        if (this.topic == null) {
            this.topic = this.instance.getTopic("org.apache.karaf.cellar.event.topic");
        }
    }

    public void destroy() {
    }

    public void produce(E event) {
        if (this.getSwitch().getStatus().equals((Object)SwitchStatus.ON) || event.getForce().booleanValue() || event instanceof Result) {
            if (event instanceof Result || event instanceof Command) {
                event.setSourceNode(this.node);
            }
            this.topic.publish(event);
        } else if (this.eventSwitch.getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR HAZELCAST: {} switch is OFF, don't produce the cluster event", (Object)SWITCH_ID);
        }
    }

    public Switch getSwitch() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            if (configuration != null) {
                Boolean status = new Boolean((String)configuration.getProperties().get("producer"));
                if (status.booleanValue()) {
                    this.eventSwitch.turnOn();
                } else {
                    this.eventSwitch.turnOff();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.eventSwitch;
    }

    public ITopic<? extends Event> getTopic() {
        return this.topic;
    }

    public void setTopic(ITopic<Event> topic) {
        this.topic = topic;
    }

    public HazelcastInstance getInstance() {
        return this.instance;
    }

    public void setInstance(HazelcastInstance instance) {
        this.instance = instance;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }
}

