/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.InfoList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class AnnotationInfoList
extends InfoList.MappableInfoList<AnnotationInfo> {
    private final AnnotationInfoList directlyRelatedAnnotations;
    static final AnnotationInfoList EMPTY_LIST = new AnnotationInfoList(){

        @Override
        public boolean add(AnnotationInfo e) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void add(int index, AnnotationInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean remove(Object o) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public AnnotationInfo remove(int index) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(Collection<? extends AnnotationInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean addAll(int index, Collection<? extends AnnotationInfo> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public void clear() {
            throw new IllegalArgumentException("List is immutable");
        }

        @Override
        public AnnotationInfo set(int index, AnnotationInfo element) {
            throw new IllegalArgumentException("List is immutable");
        }
    };

    AnnotationInfoList() {
        this.directlyRelatedAnnotations = null;
    }

    AnnotationInfoList(int sizeHint) {
        super(sizeHint);
        this.directlyRelatedAnnotations = null;
    }

    AnnotationInfoList(AnnotationInfoList reachableAnnotations) {
        this(reachableAnnotations, reachableAnnotations);
    }

    AnnotationInfoList(AnnotationInfoList reachableAnnotations, AnnotationInfoList directlyRelatedAnnotations) {
        super(reachableAnnotations);
        this.directlyRelatedAnnotations = directlyRelatedAnnotations;
    }

    public AnnotationInfoList filter(AnnotationInfoFilter filter) {
        AnnotationInfoList annotationInfoFiltered = new AnnotationInfoList();
        for (AnnotationInfo resource : this) {
            if (!filter.accept(resource)) continue;
            annotationInfoFiltered.add(resource);
        }
        return annotationInfoFiltered;
    }

    void getReferencedClassNames(Set<String> refdClassNames) {
        for (AnnotationInfo ai : this) {
            ai.getReferencedClassNames(refdClassNames);
        }
    }

    private static void findMetaAnnotations(AnnotationInfo ai, AnnotationInfoList allAnnotationsOut, Set<ClassInfo> visited) {
        ClassInfo annotationClassInfo = ai.getClassInfo();
        if (annotationClassInfo != null && annotationClassInfo.annotationInfo != null && visited.add(annotationClassInfo)) {
            for (AnnotationInfo metaAnnotationInfo : annotationClassInfo.annotationInfo) {
                ClassInfo metaAnnotationClassInfo = metaAnnotationInfo.getClassInfo();
                String metaAnnotationClassName = metaAnnotationClassInfo.getName();
                if (metaAnnotationClassName.startsWith("java.lang.annotation.")) continue;
                allAnnotationsOut.add(metaAnnotationInfo);
                AnnotationInfoList.findMetaAnnotations(metaAnnotationInfo, allAnnotationsOut, visited);
            }
        }
    }

    static AnnotationInfoList getIndirectAnnotations(AnnotationInfoList directAnnotationInfo, ClassInfo annotatedClass) {
        HashSet<ClassInfo> directOrInheritedAnnotationClasses = new HashSet<ClassInfo>();
        HashSet<ClassInfo> reachedAnnotationClasses = new HashSet<ClassInfo>();
        AnnotationInfoList reachableAnnotationInfo = new AnnotationInfoList(directAnnotationInfo == null ? 2 : directAnnotationInfo.size());
        if (directAnnotationInfo != null) {
            for (AnnotationInfo dai : directAnnotationInfo) {
                directOrInheritedAnnotationClasses.add(dai.getClassInfo());
                reachableAnnotationInfo.add(dai);
                AnnotationInfoList.findMetaAnnotations(dai, reachableAnnotationInfo, reachedAnnotationClasses);
            }
        }
        if (annotatedClass != null) {
            for (ClassInfo superclass : annotatedClass.getSuperclasses()) {
                if (superclass.annotationInfo == null) continue;
                for (AnnotationInfo sai : superclass.annotationInfo) {
                    if (!sai.isInherited() || !directOrInheritedAnnotationClasses.add(sai.getClassInfo())) continue;
                    reachableAnnotationInfo.add(sai);
                    AnnotationInfoList reachableMetaAnnotationInfo = new AnnotationInfoList(2);
                    AnnotationInfoList.findMetaAnnotations(sai, reachableMetaAnnotationInfo, reachedAnnotationClasses);
                    for (AnnotationInfo rmai : reachableMetaAnnotationInfo) {
                        if (!rmai.isInherited()) continue;
                        reachableAnnotationInfo.add(rmai);
                    }
                }
            }
        }
        AnnotationInfoList directAnnotationInfoSorted = directAnnotationInfo == null ? EMPTY_LIST : new AnnotationInfoList(directAnnotationInfo);
        Collections.sort(directAnnotationInfoSorted);
        AnnotationInfoList annotationInfoList = new AnnotationInfoList(reachableAnnotationInfo, directAnnotationInfoSorted);
        Collections.sort(annotationInfoList);
        return annotationInfoList;
    }

    public AnnotationInfoList directOnly() {
        return this.directlyRelatedAnnotations == null ? this : new AnnotationInfoList(this.directlyRelatedAnnotations, null);
    }

    @FunctionalInterface
    public static interface AnnotationInfoFilter {
        public boolean accept(AnnotationInfo var1);
    }
}

