/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.cm.impl.ActivatorWorkerQueue;
import org.apache.felix.cm.impl.ConfigurationAdminStarter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationPlugin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class RequiredConfigurationPluginTracker
implements ServiceTrackerCustomizer<ConfigurationPlugin, ConfigurationPlugin> {
    public static final String PROPERTY_NAME = "config.plugin.id";
    private final ServiceTracker<ConfigurationPlugin, ConfigurationPlugin> pluginTracker;
    private final BundleContext bundleContext;
    private final ConcurrentHashMap<String, AtomicInteger> serviceMap = new ConcurrentHashMap();
    private final Map<Long, String> idToNameMap = new ConcurrentHashMap<Long, String>();
    private final ConfigurationAdminStarter starter;
    private final Set<String> requiredNames = new HashSet<String>();
    private final Set<String> registeredPluginNames = new TreeSet<String>();
    private final ActivatorWorkerQueue workerQueue;

    public RequiredConfigurationPluginTracker(BundleContext bundleContext, ActivatorWorkerQueue workerQueue, ConfigurationAdminStarter starter, String[] pluginNames) throws BundleException, InvalidSyntaxException {
        this.workerQueue = workerQueue;
        this.starter = starter;
        for (String name : pluginNames) {
            this.requiredNames.add(name);
        }
        this.bundleContext = bundleContext;
        this.pluginTracker = new ServiceTracker(bundleContext, ConfigurationPlugin.class, (ServiceTrackerCustomizer)this);
        this.pluginTracker.open();
    }

    public void stop() {
        if (this.pluginTracker != null) {
            this.pluginTracker.close();
        }
    }

    private boolean hasRequiredPlugins() {
        for (String name : this.requiredNames) {
            AtomicInteger v = this.serviceMap.get(name);
            if (v != null && v.get() != 0) continue;
            return false;
        }
        return true;
    }

    public ConfigurationPlugin addingService(ServiceReference<ConfigurationPlugin> reference) {
        ConfigurationPlugin plugin = null;
        Object nameObj = reference.getProperty(PROPERTY_NAME);
        if (nameObj != null) {
            final String name = nameObj.toString();
            this.idToNameMap.put((Long)reference.getProperty("service.id"), name);
            this.serviceMap.putIfAbsent(name, new AtomicInteger());
            AtomicInteger counter = this.serviceMap.get(name);
            boolean checkActivate = counter.getAndIncrement() == 0;
            boolean activate = false;
            if (this.requiredNames.contains(name) && (plugin = (ConfigurationPlugin)this.bundleContext.getService(reference)) != null) {
                activate = checkActivate && this.hasRequiredPlugins();
            }
            final boolean activateCA = activate;
            this.workerQueue.enqueue(new Runnable(){

                @Override
                public void run() {
                    if (activateCA) {
                        RequiredConfigurationPluginTracker.this.starter.updatePluginsSet(true);
                    }
                    RequiredConfigurationPluginTracker.this.registeredPluginNames.add(name);
                    RequiredConfigurationPluginTracker.this.updateRegisteredConfigurationPlugins();
                }
            });
        }
        return plugin;
    }

    public void modifiedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
        this.removedService(reference, service);
        this.addingService((ServiceReference)reference);
    }

    public void removedService(ServiceReference<ConfigurationPlugin> reference, ConfigurationPlugin service) {
        final String name = this.idToNameMap.remove(reference.getProperty("service.id"));
        if (name != null) {
            boolean deactivate;
            AtomicInteger counter = this.serviceMap.get(name);
            boolean bl = deactivate = counter.decrementAndGet() == 0;
            if (this.requiredNames.contains(name)) {
                this.bundleContext.ungetService(reference);
            }
            if (deactivate) {
                this.workerQueue.enqueue(new Runnable(){

                    @Override
                    public void run() {
                        if (!RequiredConfigurationPluginTracker.this.hasRequiredPlugins()) {
                            RequiredConfigurationPluginTracker.this.starter.updatePluginsSet(false);
                        }
                        RequiredConfigurationPluginTracker.this.registeredPluginNames.remove(name);
                        RequiredConfigurationPluginTracker.this.updateRegisteredConfigurationPlugins();
                    }
                });
            }
        }
    }

    private void updateRegisteredConfigurationPlugins() {
        String propValue;
        if (this.registeredPluginNames.isEmpty()) {
            propValue = "";
        } else {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String name : this.registeredPluginNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(name);
            }
            propValue = sb.toString();
        }
        this.starter.updateRegisteredConfigurationPlugins(propValue);
    }
}

