/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.command.ConfigPropertyCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="config", name="property-list", description="Lists properties from the currently edited configuration.")
@Service
public class PropListCommand
extends ConfigPropertyCommandSupport {
    @Option(name="--raw")
    boolean raw;

    @Override
    public void propertyAction(TypedProperties props) {
        if (this.raw) {
            try {
                StringWriter sw = new StringWriter();
                props.save(sw);
                System.out.print(sw.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            StringWriter sw = new StringWriter();
            props.save(sw);
            TypedProperties p = new TypedProperties();
            p.load(new StringReader(sw.toString()));
            props = p;
        }
        catch (IOException sw) {
            // empty catch block
        }
        TreeMap<String, Object> sortedProps = new TreeMap<String, Object>(props);
        for (Map.Entry entry : sortedProps.entrySet()) {
            System.out.println("   " + (String)entry.getKey() + " = " + this.displayValue(entry.getValue()));
        }
    }

    @Override
    protected boolean requiresUpdate(String pid) {
        return false;
    }
}

