/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.group;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.control.ManageGroupAction;
import org.apache.karaf.cellar.core.control.ManageGroupCommand;
import org.apache.karaf.cellar.core.control.ManageGroupResult;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.support.table.ShellTable;

public abstract class GroupSupport
extends ClusterCommandSupport {
    protected Object doExecute(ManageGroupAction action, String group, Group source, Collection<String> nodes) throws Exception {
        return this.doExecute(action, group, source, nodes, true);
    }

    protected Object doExecute(ManageGroupAction action, String group, Group source, Collection<String> nodeIdsOrAliases, Boolean suppressOutput) throws Exception {
        ManageGroupCommand command = new ManageGroupCommand(this.clusterManager.generateId());
        command.setTimeout(this.timeout * 1000L);
        HashSet<Node> recipientList = new HashSet<Node>();
        if (nodeIdsOrAliases != null && !nodeIdsOrAliases.isEmpty()) {
            for (String nodeIdOrAlias : nodeIdsOrAliases) {
                Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
                if (node == null) {
                    System.err.println("Cluster node " + nodeIdOrAlias + " doesn't exist");
                    continue;
                }
                recipientList.add(node);
            }
        } else {
            recipientList.add(this.clusterManager.getNode());
        }
        if (recipientList.size() < 1) {
            return null;
        }
        command.setDestination(recipientList);
        command.setAction(action);
        if (group != null) {
            command.setGroupName(group);
        }
        if (source != null) {
            command.setSourceGroup(source);
        }
        Map results = this.executionContext.execute((Command)command);
        if (!suppressOutput.booleanValue()) {
            if (results == null || results.isEmpty()) {
                System.out.println("No result received within given timeout");
            } else {
                ShellTable table = new ShellTable();
                table.column(" ");
                table.column("Group");
                table.column("Members");
                for (Node node : results.keySet()) {
                    ManageGroupResult result = (ManageGroupResult)results.get(node);
                    if (result == null || result.getGroups() == null) continue;
                    for (Group g : result.getGroups()) {
                        StringBuffer buffer = new StringBuffer();
                        if (g.getNodes() != null && !g.getNodes().isEmpty()) {
                            String local = "";
                            for (Node member : g.getNodes()) {
                                if (this.clusterManager.findNodeById(member.getId()) == null) continue;
                                if (member.getAlias() != null) {
                                    buffer.append(member.getAlias());
                                } else {
                                    buffer.append(member.getId());
                                }
                                if (member.equals(this.clusterManager.getNode())) {
                                    local = "x";
                                    buffer.append("(x)");
                                }
                                buffer.append(" ");
                            }
                            table.addRow().addContent(new Object[]{local, g.getName(), buffer.toString()});
                            continue;
                        }
                        table.addRow().addContent(new Object[]{"", g.getName(), ""});
                    }
                }
                table.print(System.out);
            }
        }
        return null;
    }
}

