/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TransactionToken;
import org.apache.aries.transaction.annotations.TransactionPropagationType;

public enum TransactionAttribute {
    MANDATORY{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 6) {
                throw new IllegalStateException(Constants.MESSAGES.getMessage("tran.not.found", new Object[0]));
            }
            return new TransactionToken(man.getTransaction(), null, MANDATORY);
        }
    }
    ,
    NEVER{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                throw new IllegalStateException(Constants.MESSAGES.getMessage("tran.found.never", new Object[0]));
            }
            return new TransactionToken(null, null, NEVER);
        }
    }
    ,
    NOTSUPPORTED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException {
            if (man.getStatus() == 0) {
                return new TransactionToken(null, man.suspend(), this);
            }
            return new TransactionToken(null, null, NOTSUPPORTED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException {
            Transaction tran = tranToken.getSuspendedTransaction();
            if (tran != null) {
                man.resume(tran);
            }
        }
    }
    ,
    REQUIRED{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException {
            if (man.getStatus() == 6) {
                man.begin();
                return new TransactionToken(man.getTransaction(), null, REQUIRED, true);
            }
            return new TransactionToken(man.getTransaction(), null, REQUIRED);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
        }
    }
    ,
    REQUIRESNEW{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            Transaction suspendedTransaction = man.getStatus() == 0 ? man.suspend() : null;
            try {
                man.begin();
            }
            catch (SystemException e) {
                man.resume(suspendedTransaction);
                throw e;
            }
            catch (NotSupportedException e) {
                man.resume(suspendedTransaction);
                throw e;
            }
            return new TransactionToken(man.getTransaction(), suspendedTransaction, REQUIRESNEW, true);
        }

        @Override
        public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
            Transaction tran;
            if (tranToken.isCompletionAllowed()) {
                if (man.getStatus() == 1) {
                    man.rollback();
                } else {
                    man.commit();
                }
            }
            if ((tran = tranToken.getSuspendedTransaction()) != null) {
                man.resume(tran);
            }
        }
    }
    ,
    SUPPORTS{

        @Override
        public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
            if (man.getStatus() == 0) {
                return new TransactionToken(man.getTransaction(), null, SUPPORTS);
            }
            return new TransactionToken(null, null, SUPPORTS);
        }
    };


    public static TransactionAttribute fromValue(TransactionPropagationType type) {
        return TransactionAttribute.valueOf(type.name().toUpperCase());
    }

    public TransactionToken begin(TransactionManager man) throws SystemException, NotSupportedException, InvalidTransactionException, IllegalStateException {
        return null;
    }

    public void finish(TransactionManager man, TransactionToken tranToken) throws SystemException, InvalidTransactionException, IllegalStateException, SecurityException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
    }
}

