/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.message.MessageInfo;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JaspiMessageInfo
implements MessageInfo {
    public static final String MANDATORY_KEY = "javax.security.auth.message.MessagePolicy.isMandatory";
    public static final String AUTH_METHOD_KEY = "javax.servlet.http.authType";
    private ServletRequest request;
    private ServletResponse response;
    private final MIMap map;

    public JaspiMessageInfo(ServletRequest request, ServletResponse response, boolean isAuthMandatory) {
        this.request = request;
        this.response = response;
        this.map = new MIMap(isAuthMandatory);
    }

    public Map getMap() {
        return this.map;
    }

    public Object getRequestMessage() {
        return this.request;
    }

    public Object getResponseMessage() {
        return this.response;
    }

    public void setRequestMessage(Object request) {
        this.request = (ServletRequest)request;
    }

    public void setResponseMessage(Object response) {
        this.response = (ServletResponse)response;
    }

    public String getAuthMethod() {
        return this.map.getAuthMethod();
    }

    public boolean isAuthMandatory() {
        return this.map.isAuthMandatory();
    }

    private static class MIMap
    implements Map {
        private final boolean isMandatory;
        private String authMethod;
        private Map delegate;

        private MIMap(boolean mandatory) {
            this.isMandatory = mandatory;
        }

        @Override
        public int size() {
            return (this.isMandatory ? 1 : 0) + (this.authMethod == null ? 0 : 1) + (this.delegate == null ? 0 : this.delegate.size());
        }

        @Override
        public boolean isEmpty() {
            return !this.isMandatory && this.authMethod == null && (this.delegate == null || this.delegate.isEmpty());
        }

        @Override
        public boolean containsKey(Object key) {
            if (JaspiMessageInfo.MANDATORY_KEY.equals(key)) {
                return this.isMandatory;
            }
            if (JaspiMessageInfo.AUTH_METHOD_KEY.equals(key)) {
                return this.authMethod != null;
            }
            return this.delegate != null && this.delegate.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.isMandatory && "true".equals(value)) {
                return true;
            }
            if (this.authMethod == value || this.authMethod != null && this.authMethod.equals(value)) {
                return true;
            }
            return this.delegate != null && this.delegate.containsValue(value);
        }

        public Object get(Object key) {
            if (JaspiMessageInfo.MANDATORY_KEY.equals(key)) {
                return this.isMandatory ? "true" : null;
            }
            if (JaspiMessageInfo.AUTH_METHOD_KEY.equals(key)) {
                return this.authMethod;
            }
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.get(key);
        }

        public Object put(Object key, Object value) {
            if (JaspiMessageInfo.MANDATORY_KEY.equals(key)) {
                throw new IllegalArgumentException("Mandatory not mutable");
            }
            if (JaspiMessageInfo.AUTH_METHOD_KEY.equals(key)) {
                String authMethod = this.authMethod;
                this.authMethod = (String)value;
                if (this.delegate != null) {
                    this.delegate.put(JaspiMessageInfo.AUTH_METHOD_KEY, value);
                }
                return authMethod;
            }
            return this.getDelegate(true).put(key, value);
        }

        public Object remove(Object key) {
            if (JaspiMessageInfo.MANDATORY_KEY.equals(key)) {
                throw new IllegalArgumentException("Mandatory not mutable");
            }
            if (JaspiMessageInfo.AUTH_METHOD_KEY.equals(key)) {
                String authMethod = this.authMethod;
                this.authMethod = null;
                if (this.delegate != null) {
                    this.delegate.remove(JaspiMessageInfo.AUTH_METHOD_KEY);
                }
                return authMethod;
            }
            if (this.delegate == null) {
                return null;
            }
            return this.delegate.remove(key);
        }

        public void putAll(Map map) {
            if (map != null) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    this.put(entry.getKey(), entry.getValue());
                }
            }
        }

        @Override
        public void clear() {
            this.authMethod = null;
            this.delegate = null;
        }

        public Set keySet() {
            return this.getDelegate(true).keySet();
        }

        public Collection values() {
            return this.getDelegate(true).values();
        }

        public Set entrySet() {
            return this.getDelegate(true).entrySet();
        }

        private Map getDelegate(boolean create) {
            if (!create || this.delegate != null) {
                return this.delegate;
            }
            if (create) {
                this.delegate = new HashMap();
                if (this.isMandatory) {
                    this.delegate.put(JaspiMessageInfo.MANDATORY_KEY, "true");
                }
                if (this.authMethod != null) {
                    this.delegate.put(JaspiMessageInfo.AUTH_METHOD_KEY, this.authMethod);
                }
            }
            return this.delegate;
        }

        boolean isAuthMandatory() {
            return this.isMandatory;
        }

        String getAuthMethod() {
            return this.authMethod;
        }
    }
}

