/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

public class ScriptProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable,
IdAware {
    private String id;
    private final Expression expression;

    public ScriptProcessor(Expression expression) {
        ObjectHelper.notNull(expression, "expression", this);
        this.expression = expression;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.expression.evaluate(exchange, Object.class);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "Script(" + this.expression + ")";
    }

    @Override
    public String getTraceLabel() {
        return "script[" + this.expression + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

