/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.rules.RuleStatistics;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="rule-list", description="This will list all the rules deployed in the Apache Unomi Context Server")
@Service
public class RuleList
extends ListCommandSupport {
    @Reference
    RulesService rulesService;
    @Reference
    DefinitionsService definitionsService;
    @Argument(index=0, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;

    @Override
    protected String[] getHeaders() {
        return new String[]{"Activated", "Hidden", "Read-only", "Identifier", "Scope", "Name", "Tags", "System tags", "Executions", "Conditions [ms]", "Actions [ms]"};
    }

    @Override
    protected DataTable buildDataTable() {
        Query query = new Query();
        Condition matchAllCondition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        query.setCondition(matchAllCondition);
        query.setLimit(this.maxEntries);
        PartialList ruleMetadatas = this.rulesService.getRuleMetadatas(query);
        if ((long)ruleMetadatas.getList().size() != ruleMetadatas.getTotalSize()) {
            System.out.println("WARNING : Only the first " + ruleMetadatas.getPageSize() + " rules have been retrieved, there are " + ruleMetadatas.getTotalSize() + " rules registered in total. Use the maxEntries parameter to retrieve more rules");
        }
        Map allRuleStatistics = this.rulesService.getAllRuleStatistics();
        DataTable dataTable = new DataTable();
        for (Metadata ruleMetadata : ruleMetadatas.getList()) {
            ArrayList<Object> rowData = new ArrayList<Object>();
            String ruleId = ruleMetadata.getId();
            rowData.add(ruleMetadata.isEnabled() ? "x" : "");
            rowData.add(ruleMetadata.isHidden() ? "x" : "");
            rowData.add(ruleMetadata.isReadOnly() ? "x" : "");
            rowData.add(ruleId);
            rowData.add(ruleMetadata.getScope());
            rowData.add(ruleMetadata.getName());
            rowData.add(StringUtils.join((Iterable)ruleMetadata.getTags(), (String)","));
            rowData.add(StringUtils.join((Iterable)ruleMetadata.getSystemTags(), (String)","));
            RuleStatistics ruleStatistics = (RuleStatistics)allRuleStatistics.get(ruleId);
            if (ruleStatistics != null) {
                rowData.add(ruleStatistics.getExecutionCount());
                rowData.add(ruleStatistics.getConditionsTime());
                rowData.add(ruleStatistics.getActionsTime());
            } else {
                rowData.add(0L);
                rowData.add(0L);
                rowData.add(0L);
            }
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        dataTable.sort(new DataTable.SortCriteria[]{new DataTable.SortCriteria(Integer.valueOf(9), DataTable.SortOrder.DESCENDING), new DataTable.SortCriteria(Integer.valueOf(10), DataTable.SortOrder.DESCENDING), new DataTable.SortCriteria(Integer.valueOf(5), DataTable.SortOrder.ASCENDING)});
        return dataTable;
    }
}

