/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.version;

import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.bnd.version.maven.ComparableVersion;
import aQute.lib.date.Dates;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MavenVersion
implements Comparable<MavenVersion> {
    private static final Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([-.]?(.*))?");
    private static final Pattern fuzzyVersionRange = Pattern.compile("(\\(|\\[)\\s*([-.\\w]+)\\s*,\\s*([-.\\w]+)\\s*(\\]|\\))");
    private static final String VERSION_STRING = "(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?";
    private static final Pattern VERSION = Pattern.compile("(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?");
    private static final Pattern VERSIONRANGE = Pattern.compile("((\\(|\\[)(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?,(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?(\\]|\\)))|(\\d{1,10})(\\.(\\d{1,10})(\\.(\\d{1,10})(\\.([-\\w]+))?)?)?");
    private static final DateTimeFormatter MAVEN_SNAPSHOT_DATE_TIME = DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss", Locale.ROOT).withZone(Dates.UTC_ZONE_ID);
    public static final MavenVersion UNRESOLVED = new MavenVersion("0-UNRESOLVED");
    private static final String SNAPSHOT = "SNAPSHOT";
    public static final MavenVersion HIGHEST = new MavenVersion("2147483647.2147483647.2147483647.2147483647");
    public static final MavenVersion LOWEST = new MavenVersion("alpha");
    private final Version version;
    private final ComparableVersion comparable;

    public MavenVersion(Version osgiVersion) {
        this.version = osgiVersion;
        this.comparable = new ComparableVersion(osgiVersion.toMavenString());
    }

    public MavenVersion(String maven) {
        this.version = new Version(MavenVersion.cleanupVersion(maven));
        this.comparable = new ComparableVersion(maven != null ? maven : "");
    }

    public static final MavenVersion parseString(String osgiVersionStr) {
        if (osgiVersionStr == null) {
            osgiVersionStr = "0";
        } else if ((osgiVersionStr = osgiVersionStr.trim()).isEmpty()) {
            osgiVersionStr = "0";
        }
        Matcher m = VERSION.matcher(osgiVersionStr);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid syntax for version: " + osgiVersionStr);
        }
        int major = Integer.parseInt(m.group(1));
        int minor = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
        int micro = m.group(5) != null ? Integer.parseInt(m.group(5)) : 0;
        String qualifier = m.group(7);
        Version version = new Version(major, minor, micro, qualifier);
        return new MavenVersion(version);
    }

    public static final MavenVersion parseMavenString(String versionStr) {
        try {
            return new MavenVersion(versionStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Version getOSGiVersion() {
        return this.version;
    }

    public boolean isSnapshot() {
        return this.version.isSnapshot();
    }

    @Override
    public int compareTo(MavenVersion other) {
        if (other == this) {
            return 0;
        }
        return this.comparable.compareTo(other.comparable);
    }

    public String toString() {
        return this.comparable.toString();
    }

    public int hashCode() {
        return this.comparable.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenVersion other = (MavenVersion)obj;
        return this.comparable.equals(other.comparable);
    }

    public MavenVersion toSnapshot() {
        Version newv = new Version(this.version.getMajor(), this.version.getMinor(), this.version.getMicro(), SNAPSHOT);
        return new MavenVersion(newv);
    }

    public static String validate(String v) {
        if (v == null) {
            return "Version is null";
        }
        if (!VERSION.matcher(v).matches()) {
            return "Not a version";
        }
        return null;
    }

    public static String toDateStamp(long epoch) {
        return Dates.formatMillis(MAVEN_SNAPSHOT_DATE_TIME, epoch);
    }

    public static String toDateStamp(long epoch, String build) {
        String s = MavenVersion.toDateStamp(epoch);
        if (build != null) {
            s = String.valueOf(s) + "-" + build;
        }
        return s;
    }

    public MavenVersion toSnapshot(long epoch, String build) {
        return this.toSnapshot(MavenVersion.toDateStamp(epoch, build));
    }

    public MavenVersion toSnapshot(String timestamp, String build) {
        if (build != null) {
            timestamp = String.valueOf(timestamp) + "-" + build;
        }
        return this.toSnapshot(timestamp);
    }

    public MavenVersion toSnapshot(String dateStamp) {
        String literal = this.comparable.toString();
        String clean = literal.substring(0, literal.length() - 9);
        String result = String.valueOf(clean) + "-" + dateStamp;
        return new MavenVersion(result);
    }

    public static String cleanupVersion(String version) {
        String major;
        if (version == null || (version = version.trim()).isEmpty()) {
            return "0";
        }
        Matcher m = VERSIONRANGE.matcher(version);
        if (m.matches()) {
            try {
                VersionRange vr = new VersionRange(version);
                return version;
            }
            catch (Exception vr) {
                // empty catch block
            }
        }
        StringBuilder result = new StringBuilder();
        m = fuzzyVersionRange.matcher(version);
        if (m.matches()) {
            String prefix = m.group(1);
            String first = m.group(2);
            String last = m.group(3);
            String suffix = m.group(4);
            result.append(prefix).append(MavenVersion.cleanupVersion(first)).append(',').append(MavenVersion.cleanupVersion(last)).append(suffix);
            return result.toString();
        }
        m = fuzzyVersion.matcher(version);
        if (m.matches() && MavenVersion.isInteger(major = MavenVersion.removeLeadingZeroes(m.group(1)))) {
            result.append(major);
            String minor = MavenVersion.removeLeadingZeroes(m.group(3));
            if (!MavenVersion.isInteger(minor)) {
                String qualifier;
                result.append(".0.0.").append(minor);
                String micro = m.group(4);
                if (micro != null) {
                    MavenVersion.cleanupModifier(result, micro);
                }
                if (!(qualifier = m.group(6)).isEmpty()) {
                    MavenVersion.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
            result.append('.').append(minor);
            String micro = MavenVersion.removeLeadingZeroes(m.group(5));
            if (!MavenVersion.isInteger(micro)) {
                result.append(".0.").append(micro);
                String qualifier = m.group(6);
                if (!qualifier.isEmpty()) {
                    MavenVersion.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
            result.append('.').append(micro);
            String qualifier = m.group(7);
            if (!qualifier.isEmpty()) {
                result.append('.');
                MavenVersion.cleanupModifier(result, qualifier);
            }
            return result.toString();
        }
        result.append("0.0.0.");
        MavenVersion.cleanupModifier(result, version);
        return result.toString();
    }

    private static boolean isInteger(String minor) {
        return minor.length() < 10 || minor.length() == 10 && minor.compareTo("2147483647") <= 0;
    }

    private static String removeLeadingZeroes(String group) {
        if (group == null) {
            return "0";
        }
        int n = 0;
        while (n < group.length() - 1 && group.charAt(n) == '0') {
            ++n;
        }
        if (n == 0) {
            return group;
        }
        return group.substring(n);
    }

    static void cleanupModifier(StringBuilder result, String modifier) {
        int l = result.length();
        int i = 0;
        while (i < modifier.length()) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
            }
            ++i;
        }
        if (l == result.length()) {
            result.append("_");
        }
    }
}

