/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.download.impl;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.karaf.features.internal.download.impl.AbstractDownloadTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRetryableDownloadTask
extends AbstractDownloadTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRetryableDownloadTask.class);
    private long scheduleDelay = 250L;
    private int scheduleMaxRun = 9;
    private int scheduleNbRun = 0;
    private Exception previousException = null;

    public AbstractRetryableDownloadTask(ScheduledExecutorService executorService, String url) {
        super(executorService, url);
    }

    public long getScheduleDelay() {
        return this.scheduleDelay;
    }

    public void setScheduleDelay(long scheduleDelay) {
        this.scheduleDelay = scheduleDelay;
    }

    public int getScheduleMaxRun() {
        return this.scheduleMaxRun;
    }

    public void setScheduleMaxRun(int scheduleMaxRun) {
        this.scheduleMaxRun = scheduleMaxRun;
    }

    @Override
    public void run() {
        block8: {
            try {
                try {
                    File file = this.download(this.previousException);
                    this.setFile(file);
                }
                catch (IOException e) {
                    Retry retry = this.isRetryable(e);
                    int retryCount = this.scheduleMaxRun;
                    if (retry == Retry.QUICK_RETRY) {
                        retryCount /= 2;
                    } else if (retry == Retry.NO_RETRY) {
                        retryCount = 0;
                    }
                    if (++this.scheduleNbRun < retryCount) {
                        this.previousException = e;
                        long delay = (long)((double)(this.scheduleDelay * 3L / 2L) + Math.random() * (double)this.scheduleDelay / 2.0);
                        LOGGER.debug("Error downloading " + this.url + ": " + e.getMessage() + ". " + (Object)((Object)retry) + " in approx " + delay + " ms.");
                        this.executorService.schedule(this, delay, TimeUnit.MILLISECONDS);
                        this.scheduleDelay *= 2L;
                        break block8;
                    }
                    this.setException(new IOException("Error downloading " + this.url, e));
                }
            }
            catch (Throwable e) {
                this.setException(new IOException("Error downloading " + this.url, e));
            }
        }
    }

    protected Retry isRetryable(IOException e) {
        return Retry.DEFAULT_RETRY;
    }

    protected abstract File download(Exception var1) throws Exception;

    protected static enum Retry {
        NO_RETRY,
        QUICK_RETRY,
        DEFAULT_RETRY;

    }
}

