/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.client.ml.filestructurefinder.FileStructure;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FindFileStructureRequest
implements Validatable,
ToXContentFragment {
    public static final ParseField LINES_TO_SAMPLE = new ParseField("lines_to_sample", new String[0]);
    public static final ParseField LINE_MERGE_SIZE_LIMIT = new ParseField("line_merge_size_limit", new String[0]);
    public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
    public static final ParseField CHARSET = FileStructure.CHARSET;
    public static final ParseField FORMAT = FileStructure.FORMAT;
    public static final ParseField COLUMN_NAMES = FileStructure.COLUMN_NAMES;
    public static final ParseField HAS_HEADER_ROW = FileStructure.HAS_HEADER_ROW;
    public static final ParseField DELIMITER = FileStructure.DELIMITER;
    public static final ParseField QUOTE = FileStructure.QUOTE;
    public static final ParseField SHOULD_TRIM_FIELDS = FileStructure.SHOULD_TRIM_FIELDS;
    public static final ParseField GROK_PATTERN = FileStructure.GROK_PATTERN;
    public static final ParseField TIMESTAMP_FORMAT = new ParseField("timestamp_format", new String[0]);
    public static final ParseField TIMESTAMP_FIELD = FileStructure.TIMESTAMP_FIELD;
    public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
    private Integer linesToSample;
    private Integer lineMergeSizeLimit;
    private TimeValue timeout;
    private String charset;
    private FileStructure.Format format;
    private List<String> columnNames;
    private Boolean hasHeaderRow;
    private Character delimiter;
    private Character quote;
    private Boolean shouldTrimFields;
    private String grokPattern;
    private String timestampFormat;
    private String timestampField;
    private Boolean explain;
    private BytesReference sample;

    public Integer getLinesToSample() {
        return this.linesToSample;
    }

    public void setLinesToSample(Integer linesToSample) {
        this.linesToSample = linesToSample;
    }

    public Integer getLineMergeSizeLimit() {
        return this.lineMergeSizeLimit;
    }

    public void setLineMergeSizeLimit(Integer lineMergeSizeLimit) {
        this.lineMergeSizeLimit = lineMergeSizeLimit;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset == null || charset.isEmpty() ? null : charset;
    }

    public FileStructure.Format getFormat() {
        return this.format;
    }

    public void setFormat(FileStructure.Format format) {
        this.format = format;
    }

    public void setFormat(String format) {
        this.format = format == null || format.isEmpty() ? null : FileStructure.Format.fromString(format);
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames == null || columnNames.isEmpty() ? null : columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames == null || columnNames.length == 0 ? null : Arrays.asList(columnNames);
    }

    public Boolean getHasHeaderRow() {
        return this.hasHeaderRow;
    }

    public void setHasHeaderRow(Boolean hasHeaderRow) {
        this.hasHeaderRow = hasHeaderRow;
    }

    public Character getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(Character delimiter) {
        this.delimiter = delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (delimiter == null || delimiter.isEmpty()) {
            this.delimiter = null;
        } else if (delimiter.length() == 1) {
            this.delimiter = Character.valueOf(delimiter.charAt(0));
        } else {
            throw new IllegalArgumentException(DELIMITER.getPreferredName() + " must be a single character");
        }
    }

    public Character getQuote() {
        return this.quote;
    }

    public void setQuote(Character quote) {
        this.quote = quote;
    }

    public void setQuote(String quote) {
        if (quote == null || quote.isEmpty()) {
            this.quote = null;
        } else if (quote.length() == 1) {
            this.quote = Character.valueOf(quote.charAt(0));
        } else {
            throw new IllegalArgumentException(QUOTE.getPreferredName() + " must be a single character");
        }
    }

    public Boolean getShouldTrimFields() {
        return this.shouldTrimFields;
    }

    public void setShouldTrimFields(Boolean shouldTrimFields) {
        this.shouldTrimFields = shouldTrimFields;
    }

    public String getGrokPattern() {
        return this.grokPattern;
    }

    public void setGrokPattern(String grokPattern) {
        this.grokPattern = grokPattern == null || grokPattern.isEmpty() ? null : grokPattern;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public void setTimestampFormat(String timestampFormat) {
        this.timestampFormat = timestampFormat == null || timestampFormat.isEmpty() ? null : timestampFormat;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField == null || timestampField.isEmpty() ? null : timestampField;
    }

    public Boolean getExplain() {
        return this.explain;
    }

    public void setExplain(Boolean explain) {
        this.explain = explain;
    }

    public BytesReference getSample() {
        return this.sample;
    }

    public void setSample(byte[] sample) {
        this.sample = new BytesArray(sample);
    }

    public void setSample(BytesReference sample) {
        this.sample = Objects.requireNonNull(sample);
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.sample == null || this.sample.length() == 0) {
            validationException.addValidationError("sample must be specified");
        }
        return validationException.validationErrors().isEmpty() ? Optional.empty() : Optional.of(validationException);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.linesToSample != null) {
            builder.field(LINES_TO_SAMPLE.getPreferredName(), this.linesToSample);
        }
        if (this.lineMergeSizeLimit != null) {
            builder.field(LINE_MERGE_SIZE_LIMIT.getPreferredName(), this.lineMergeSizeLimit);
        }
        if (this.timeout != null) {
            builder.field(TIMEOUT.getPreferredName(), this.timeout);
        }
        if (this.charset != null) {
            builder.field(CHARSET.getPreferredName(), this.charset);
        }
        if (this.format != null) {
            builder.field(FORMAT.getPreferredName(), (Object)this.format);
        }
        if (this.columnNames != null) {
            builder.field(COLUMN_NAMES.getPreferredName(), this.columnNames);
        }
        if (this.hasHeaderRow != null) {
            builder.field(HAS_HEADER_ROW.getPreferredName(), this.hasHeaderRow);
        }
        if (this.delimiter != null) {
            builder.field(DELIMITER.getPreferredName(), this.delimiter.toString());
        }
        if (this.quote != null) {
            builder.field(QUOTE.getPreferredName(), this.quote.toString());
        }
        if (this.shouldTrimFields != null) {
            builder.field(SHOULD_TRIM_FIELDS.getPreferredName(), this.shouldTrimFields);
        }
        if (this.grokPattern != null) {
            builder.field(GROK_PATTERN.getPreferredName(), this.grokPattern);
        }
        if (this.timestampFormat != null) {
            builder.field(TIMESTAMP_FORMAT.getPreferredName(), this.timestampFormat);
        }
        if (this.timestampField != null) {
            builder.field(TIMESTAMP_FIELD.getPreferredName(), this.timestampField);
        }
        if (this.explain != null) {
            builder.field(EXPLAIN.getPreferredName(), this.explain);
        }
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linesToSample, this.lineMergeSizeLimit, this.timeout, this.charset, this.format, this.columnNames, this.hasHeaderRow, this.delimiter, this.grokPattern, this.timestampFormat, this.timestampField, this.explain, this.sample});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FindFileStructureRequest that = (FindFileStructureRequest)other;
        return Objects.equals(this.linesToSample, that.linesToSample) && Objects.equals(this.lineMergeSizeLimit, that.lineMergeSizeLimit) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.charset, that.charset) && Objects.equals((Object)this.format, (Object)that.format) && Objects.equals(this.columnNames, that.columnNames) && Objects.equals(this.hasHeaderRow, that.hasHeaderRow) && Objects.equals(this.delimiter, that.delimiter) && Objects.equals(this.grokPattern, that.grokPattern) && Objects.equals(this.timestampFormat, that.timestampFormat) && Objects.equals(this.timestampField, that.timestampField) && Objects.equals(this.explain, that.explain) && Objects.equals(this.sample, that.sample);
    }
}

