/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.reindex.RejectAwareActionListener;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.threadpool.ThreadPool;

class RetryListener
implements RejectAwareActionListener<ScrollableHitSource.Response> {
    private final Logger logger;
    private final Iterator<TimeValue> retries;
    private final ThreadPool threadPool;
    private final Consumer<RejectAwareActionListener<ScrollableHitSource.Response>> retryScrollHandler;
    private final ActionListener<ScrollableHitSource.Response> delegate;
    private int retryCount = 0;

    RetryListener(Logger logger, ThreadPool threadPool, BackoffPolicy backoffPolicy, Consumer<RejectAwareActionListener<ScrollableHitSource.Response>> retryScrollHandler, ActionListener<ScrollableHitSource.Response> delegate) {
        this.logger = logger;
        this.threadPool = threadPool;
        this.retries = backoffPolicy.iterator();
        this.retryScrollHandler = retryScrollHandler;
        this.delegate = delegate;
    }

    @Override
    public void onResponse(ScrollableHitSource.Response response) {
        this.delegate.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        this.delegate.onFailure(e);
    }

    @Override
    public void onRejection(Exception e) {
        if (this.retries.hasNext()) {
            ++this.retryCount;
            TimeValue delay = this.retries.next();
            this.logger.trace(() -> new ParameterizedMessage("retrying rejected search after [{}]", (Object)delay), (Throwable)e);
            this.schedule(() -> this.retryScrollHandler.accept(this), delay);
        } else {
            this.logger.warn(() -> new ParameterizedMessage("giving up on search because we retried [{}] times without success", (Object)this.retryCount), (Throwable)e);
            this.delegate.onFailure(e);
        }
    }

    private void schedule(Runnable runnable, TimeValue delay) {
        this.threadPool.schedule(this.threadPool.preserveContext(runnable), delay, "same");
    }
}

