/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.jline;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.jline.Posix;
import org.apache.felix.gogo.jline.Shell;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.command.Job;
import org.apache.felix.service.command.Process;
import org.jline.builtins.Commands;
import org.jline.builtins.Completers;
import org.jline.builtins.Options;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.Widget;
import org.jline.terminal.Terminal;

public class Builtin {
    static final String[] functions = new String[]{"format", "getopt", "new", "set", "tac", "type", "jobs", "fg", "bg", "keymap", "setopt", "unsetopt", "complete", "history", "widget", "__files", "__directories", "__usage_completion"};
    private static final String[] packages = new String[]{"java.lang", "java.io", "java.net", "java.util"};
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    public CharSequence format(CommandSession session) {
        return this.format(session, session.get("_"));
    }

    public CharSequence format(CommandSession session, Object arg) {
        Process process = Process.Utils.current();
        CharSequence result = session.format(arg, 0);
        process.out().println(result);
        return result;
    }

    public Options getopt(List<Object> spec, Object[] args) {
        String[] optSpec = new String[spec.size()];
        for (int i = 0; i < optSpec.length; ++i) {
            optSpec[i] = spec.get(i).toString();
        }
        return Options.compile((String[])optSpec).parse(args);
    }

    public Object _new(CommandSession session, Object name, Object[] argv) throws Exception {
        Class<?> clazz = name instanceof Class ? (Class<?>)name : this.loadClass(session, name.toString());
        for (Constructor<?> c : clazz.getConstructors()) {
            Class<?>[] types = c.getParameterTypes();
            if (types.length != argv.length) continue;
            boolean match = true;
            Object[] transformed = (Object[])argv.clone();
            for (int i = 0; i < transformed.length; ++i) {
                try {
                    transformed[i] = session.convert(types[i], transformed[i]);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    match = false;
                    break;
                }
            }
            if (!match) continue;
            try {
                return c.newInstance(transformed);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw ite;
            }
        }
        throw new IllegalArgumentException("can't coerce " + Arrays.asList(argv) + " to any of " + Arrays.asList(clazz.getConstructors()));
    }

    private Class<?> loadClass(CommandSession session, String name) throws ClassNotFoundException {
        if (!name.contains(".")) {
            for (String p : packages) {
                String pkg = p + "." + name;
                try {
                    return Class.forName(pkg, true, session.classLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return Class.forName(name, true, session.classLoader());
    }

    public void set(CommandSession session, String[] argv) {
        String prefix;
        String[] usage = new String[]{"set - show session variables", "Usage: set [OPTIONS] [PREFIX]", "  -? --help                show help", "  -a --all                 show all variables, including those starting with .", "  -x                       set xtrace option", "  +x                       unset xtrace option", "If PREFIX given, then only show variable(s) starting with PREFIX"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return;
        }
        List args = opt.args();
        String string = prefix = args.isEmpty() ? "" : (String)args.get(0);
        if (opt.isSet("x")) {
            session.put("echo", true);
        } else if ("+x".equals(prefix)) {
            session.put("echo", null);
        } else {
            boolean all = opt.isSet("all");
            for (String key : new TreeSet<String>(Shell.getVariables(session))) {
                if (!key.startsWith(prefix) || key.startsWith(".") && !all && prefix.length() <= 0) continue;
                Object target = session.get(key);
                String type = null;
                String value = null;
                if (target != null) {
                    Class<?> clazz = target.getClass();
                    type = clazz.getSimpleName();
                    value = target.toString();
                }
                String trunc = value == null || value.length() < 55 ? "" : "...";
                process.out().println(String.format("%-15.15s %-15s %.45s%s", type, key, value, trunc));
            }
        }
    }

    public Object tac(CommandSession session, String[] argv) throws IOException {
        String s;
        String[] usage = new String[]{"tac - capture stdin as String or List and optionally write to file.", "Usage: tac [-al] [FILE]", "  -a --append              append to FILE", "  -l --list                return List<String>", "  -? --help                show help"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return null;
        }
        List args = opt.args();
        BufferedWriter fw = null;
        if (args.size() == 1) {
            Path path = session.currentDir().resolve((String)args.get(0));
            HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
            options.add(StandardOpenOption.WRITE);
            options.add(StandardOpenOption.CREATE);
            if (opt.isSet("append")) {
                options.add(StandardOpenOption.APPEND);
            } else {
                options.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            fw = Files.newBufferedWriter(path, StandardCharsets.UTF_8, options.toArray(new OpenOption[options.size()]));
        }
        StringWriter sw = new StringWriter();
        BufferedReader rdr = new BufferedReader(new InputStreamReader(process.in()));
        ArrayList<String> list = null;
        if (opt.isSet("list")) {
            list = new ArrayList<String>();
        }
        boolean first = true;
        while ((s = rdr.readLine()) != null) {
            if (list != null) {
                list.add(s);
            } else {
                if (!first) {
                    sw.write(32);
                }
                first = false;
                sw.write(s);
            }
            if (fw == null) continue;
            fw.write(s);
            fw.newLine();
        }
        if (fw != null) {
            fw.close();
        }
        return list != null ? list : sw.toString();
    }

    public boolean type(CommandSession session, String[] argv) throws Exception {
        String arg;
        String[] usage = new String[]{"type - show command type", "Usage: type [OPTIONS] [name[:]]", "  -a --all                 show all matches", "  -? --help                show help", "  -q --quiet               don't print anything, just return status", "  -s --scope=NAME          list all commands in named scope", "  -t --types               show full java type names"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        List args = opt.args();
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return true;
        }
        boolean all = opt.isSet("all");
        String optScope = null;
        if (opt.isSet("scope")) {
            optScope = opt.get("scope");
        }
        if (args.size() == 1 && (arg = (String)args.get(0)).endsWith(":")) {
            optScope = (String)args.remove(0);
        }
        if (optScope != null || args.isEmpty() && all) {
            TreeSet<String> snames = new TreeSet<String>();
            for (String string : Shell.getCommands(session)) {
                if (optScope != null && !string.startsWith(optScope)) continue;
                snames.add(string);
            }
            for (String string : snames) {
                process.out().println(string);
            }
            return true;
        }
        if (args.size() == 0) {
            TreeMap<String, Integer> scopes = new TreeMap<String, Integer>();
            for (String string : Shell.getCommands(session)) {
                int colon;
                String scope = string.substring(0, colon = string.indexOf(58));
                Integer count = (Integer)scopes.get(scope);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                scopes.put(scope, count);
            }
            for (Map.Entry entry : scopes.entrySet()) {
                process.out().println((String)entry.getKey() + ":" + entry.getValue());
            }
            return true;
        }
        String name = ((String)args.get(0)).toLowerCase();
        int colon = name.indexOf(58);
        String string = "_main";
        StringBuilder buf = new StringBuilder();
        LinkedHashSet<String> cmds = new LinkedHashSet<String>();
        if (colon != -1 || session.get(name) != null) {
            cmds.add(name);
        } else if (session.get("_main") != null) {
            cmds.add("_main");
        } else {
            String path = session.get("SCOPE") != null ? session.get("SCOPE").toString() : "*";
            block4: for (String s : path.split(":")) {
                if (s.equals("*")) {
                    for (String sname : Shell.getCommands(session)) {
                        if (!sname.endsWith(":" + name)) continue;
                        cmds.add(sname);
                        if (all) continue;
                        continue block4;
                    }
                    continue;
                }
                String sname = s + ":" + name;
                if (session.get(sname) == null) continue;
                cmds.add(sname);
                if (!all) break;
            }
        }
        for (String key : cmds) {
            Object target = session.get(key);
            if (target == null) continue;
            CharSequence source = this.getClosureSource(session, key);
            if (source != null) {
                buf.append(name);
                buf.append(" is function {");
                buf.append(source);
                buf.append("}");
                continue;
            }
            for (Method m : this.getMethods(session, key)) {
                StringBuilder params = new StringBuilder();
                for (Class<?> type : m.getParameterTypes()) {
                    if (params.length() > 0) {
                        params.append(", ");
                    }
                    params.append(type.getSimpleName());
                }
                String rtype = m.getReturnType().getSimpleName();
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                if (opt.isSet("types")) {
                    String cname = m.getDeclaringClass().getName();
                    buf.append(String.format("%s %s.%s(%s)", rtype, cname, m.getName(), params));
                    continue;
                }
                buf.append(String.format("%s is %s %s(%s)", name, rtype, key, params));
            }
        }
        if (buf.length() > 0) {
            if (!opt.isSet("quiet")) {
                process.out().println(buf);
            }
            return true;
        }
        if (!opt.isSet("quiet")) {
            process.err().println("type: " + name + " not found.");
        }
        return false;
    }

    public void jobs(CommandSession session, String[] argv) {
        String[] usage = new String[]{"jobs - list jobs", "Usage: jobs [OPTIONS]", "  -? --help                show help"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return;
        }
        if (!opt.args().isEmpty()) {
            process.err().println("usage: jobs");
            process.error(2);
            return;
        }
        List<Job> jobs = session.jobs();
        Job current = Job.Utils.current();
        for (Job job : jobs) {
            if (job == current) continue;
            process.out().println("[" + job.id() + "] " + job.status().toString().toLowerCase() + " " + job.command());
        }
    }

    public void fg(CommandSession session, String[] argv) {
        String[] usage = new String[]{"fg - put job in foreground", "Usage: fg [OPTIONS] [jobid]", "  -? --help                show help"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return;
        }
        if (opt.args().size() > 1) {
            process.err().println("usage: fg [jobid]");
            process.error(2);
            return;
        }
        ArrayList<Job> jobs = new ArrayList<Job>(session.jobs());
        Collections.reverse(jobs);
        Job current = Job.Utils.current();
        if (argv.length == 0) {
            Job job = jobs.stream().filter(j -> j != current).findFirst().orElse(null);
            if (job != null) {
                job.foreground();
            } else {
                process.err().println("fg: no current job");
                process.error(1);
            }
        } else {
            Job job = jobs.stream().filter(j -> j != current && argv[0].equals(Integer.toString(j.id()))).findFirst().orElse(null);
            if (job != null) {
                job.foreground();
            } else {
                process.err().println("fg: job not found: " + argv[0]);
                process.error(1);
            }
        }
    }

    public void bg(CommandSession session, String[] argv) {
        String[] usage = new String[]{"bg - put job in background", "Usage: bg [OPTIONS] [jobid]", "  -? --help                show help"};
        Process process = Process.Utils.current();
        Options opt = Options.compile((String[])usage).parse((Object[])argv);
        if (opt.isSet("help")) {
            opt.usage(process.err());
            return;
        }
        if (opt.args().size() > 1) {
            process.err().println("usage: bg [jobid]");
            process.error(2);
            return;
        }
        ArrayList<Job> jobs = new ArrayList<Job>(session.jobs());
        Collections.reverse(jobs);
        Job current = Job.Utils.current();
        if (argv.length == 0) {
            Job job = jobs.stream().filter(j -> j != current).findFirst().orElse(null);
            if (job != null) {
                job.background();
            } else {
                process.err().println("bg: no current job");
                process.error(1);
            }
        } else {
            Job job = jobs.stream().filter(j -> j != current && argv[0].equals(Integer.toString(j.id()))).findFirst().orElse(null);
            if (job != null) {
                job.background();
            } else {
                process.err().println("bg: job not found: " + argv[0]);
                process.error(1);
            }
        }
    }

    private boolean isClosure(Object target) {
        return target.getClass().getSimpleName().equals("Closure");
    }

    private boolean isCommand(Object target) {
        return target.getClass().getSimpleName().equals("CommandProxy");
    }

    private CharSequence getClosureSource(CommandSession session, String name) throws Exception {
        Object target = session.get(name);
        if (target == null) {
            return null;
        }
        if (!this.isClosure(target)) {
            return null;
        }
        Field sourceField = target.getClass().getDeclaredField("source");
        sourceField.setAccessible(true);
        return (CharSequence)sourceField.get(target);
    }

    private List<Method> getMethods(CommandSession session, String scmd) throws Exception {
        Method[] methods;
        int colon = scmd.indexOf(58);
        String function = colon == -1 ? scmd : scmd.substring(colon + 1);
        String name = KEYWORDS.contains(function) ? "_" + function : function;
        String get = "get" + function;
        String is = "is" + function;
        String set = "set" + function;
        String MAIN = "_main";
        Object target = session.get(scmd);
        if (target == null) {
            return null;
        }
        if (this.isClosure(target)) {
            return null;
        }
        if (this.isCommand(target)) {
            Method method = target.getClass().getMethod("getTarget", null);
            method.setAccessible(true);
            target = method.invoke(target, (Object[])null);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        Class<?> tc = target instanceof Class ? (Class<?>)target : target.getClass();
        for (Method m : methods = tc.getMethods()) {
            String mname = m.getName().toLowerCase();
            if (!mname.equals(name) && !mname.equals(get) && !mname.equals(set) && !mname.equals(is) && !mname.equals("_main")) continue;
            list.add(m);
        }
        return list;
    }

    public void history(CommandSession session, String[] argv) throws IOException {
        Process process = Process.Utils.current();
        Commands.history((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), (String[])argv);
    }

    public void complete(CommandSession session, String[] argv) {
        Process process = Process.Utils.current();
        Commands.complete((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), Shell.getCompletions(session), (String[])argv);
    }

    public void widget(CommandSession session, String[] argv) throws Exception {
        java.util.function.Function<String, Widget> creator = func -> () -> {
            try {
                session.execute((CharSequence)func);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        };
        Process process = Process.Utils.current();
        Commands.widget((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), creator, (String[])argv);
    }

    public void keymap(CommandSession session, String[] argv) {
        Process process = Process.Utils.current();
        Commands.keymap((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), (String[])argv);
    }

    public void setopt(CommandSession session, String[] argv) {
        Process process = Process.Utils.current();
        Commands.setopt((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), (String[])argv);
    }

    public void unsetopt(CommandSession session, String[] argv) {
        Process process = Process.Utils.current();
        Commands.unsetopt((LineReader)Shell.getReader(session), (PrintStream)process.out(), (PrintStream)process.err(), (String[])argv);
    }

    public List<Candidate> __files(final CommandSession session) {
        ParsedLine line = Shell.getParsedLine(session);
        LineReader reader = Shell.getReader(session);
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        new Completers.FilesCompleter(session.currentDir()){

            protected String getDisplay(Terminal terminal, Path p) {
                return Builtin.this.getFileDisplay(session, p);
            }
        }.complete(reader, line, candidates);
        return candidates;
    }

    public List<Candidate> __directories(final CommandSession session) {
        ParsedLine line = Shell.getParsedLine(session);
        LineReader reader = Shell.getReader(session);
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        new Completers.DirectoriesCompleter(session.currentDir()){

            protected String getDisplay(Terminal terminal, Path p) {
                return Builtin.this.getFileDisplay(session, p);
            }
        }.complete(reader, line, candidates);
        return candidates;
    }

    private String getFileDisplay(CommandSession session, Path path) {
        String suffix;
        String type;
        if (Files.isSymbolicLink(path)) {
            type = "sl";
            suffix = "@";
        } else if (Files.isDirectory(path, new LinkOption[0])) {
            type = "dr";
            suffix = "/";
        } else if (Files.isExecutable(path)) {
            type = "ex";
            suffix = "*";
        } else if (!Files.isRegularFile(path, new LinkOption[0])) {
            type = "ot";
            suffix = "";
        } else {
            type = "";
            suffix = "";
        }
        return Posix.applyStyle(path.getFileName().toString(), Posix.getLsColorMap(session), type) + suffix;
    }

    public void __usage_completion(CommandSession session, String command) throws Exception {
        Object func = session.get(command.contains(":") ? command : "*:" + command);
        if (func instanceof Function) {
            ByteArrayInputStream bais = new ByteArrayInputStream(new byte[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayOutputStream baes = new ByteArrayOutputStream();
            CommandSession ts = ((CommandSessionImpl)session).processor().createSession(bais, new PrintStream(baos), new PrintStream(baes));
            ts.execute(command + " --help");
            String regex = "(?x)\\s*(?:-([^-]))?(?:,?\\s*-(\\w))?(?:,?\\s*--(\\w[\\w-]*)(=\\w+)?)?(?:,?\\s*--(\\w[\\w-]*))?.*?(?:\\(default=(.*)\\))?\\s*(.*)";
            Pattern pattern = Pattern.compile(regex);
            for (String l : baes.toString().split("\n")) {
                Matcher matcher = pattern.matcher(l);
                if (!matcher.matches()) continue;
                ArrayList<String> args = new ArrayList<String>();
                if (matcher.group(1) != null) {
                    args.add("--short-option");
                    args.add(matcher.group(1));
                }
                if (matcher.group(3) != null) {
                    args.add("--long-option");
                    args.add(matcher.group(1));
                }
                if (matcher.group(4) != null) {
                    args.add("--argument");
                    args.add("");
                }
                if (matcher.group(7) != null) {
                    args.add("--description");
                    args.add(matcher.group(7));
                }
                this.complete(session, args.toArray(new String[args.size()]));
            }
        }
    }
}

