/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.features;

import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.apache.karaf.cellar.features.ClusterFeaturesEvent;
import org.apache.karaf.cellar.features.ClusterRepositoryEvent;
import org.apache.karaf.cellar.features.FeatureState;
import org.apache.karaf.cellar.features.FeaturesSupport;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.RepositoryEvent;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFeaturesListener
extends FeaturesSupport
implements FeaturesListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(LocalFeaturesListener.class);
    private EventProducer eventProducer;

    @Override
    public void init(BundleContext bundleContext) {
        super.init(bundleContext);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    public void featureEvent(FeatureEvent event) {
        Set groups;
        if (!this.isEnabled()) {
            LOGGER.trace("CELLAR FEATURE: local listener is disabled");
            return;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR FEATURE: cluster event producer is OFF");
            return;
        }
        if (event != null && (groups = this.groupManager.listLocalGroups()) != null && !groups.isEmpty()) {
            for (Group group : groups) {
                Feature feature = event.getFeature();
                String name = feature.getName();
                String version = feature.getVersion();
                if (this.isAllowed(group, "feature", name, EventType.OUTBOUND).booleanValue()) {
                    FeatureEvent.EventType type = event.getType();
                    Map clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + group.getName());
                    FeatureState clusterFeatureState = new FeatureState();
                    clusterFeatureState.setName(event.getFeature().getName());
                    clusterFeatureState.setVersion(event.getFeature().getVersion());
                    if (FeatureEvent.EventType.FeatureInstalled.equals((Object)event.getType())) {
                        clusterFeatureState.setInstalled(Boolean.TRUE);
                    } else {
                        clusterFeatureState.setInstalled(Boolean.FALSE);
                    }
                    clusterFeatures.put(event.getFeature().getName() + "/" + event.getFeature().getVersion(), clusterFeatureState);
                    ClusterFeaturesEvent featureEvent = new ClusterFeaturesEvent(name, version, type);
                    featureEvent.setSourceGroup(group);
                    featureEvent.setSourceNode(this.clusterManager.getNode());
                    featureEvent.setLocal(this.clusterManager.getNode());
                    this.eventProducer.produce((Event)featureEvent);
                    continue;
                }
                LOGGER.trace("CELLAR FEATURE: feature {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)name, (Object)group.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repositoryEvent(RepositoryEvent event) {
        block17: {
            if (!this.isEnabled()) {
                LOGGER.trace("CELLAR FEATURE: local listener is disabled");
                return;
            }
            if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
                LOGGER.debug("CELLAR FEATURE: cluster event producer is OFF");
                return;
            }
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Set groups;
                Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                if (event == null || event.getRepository() == null || (groups = this.groupManager.listLocalGroups()) == null || groups.isEmpty()) break block17;
                for (Group group : groups) {
                    Map clusterFeatures;
                    ClusterRepositoryEvent clusterRepositoryEvent = new ClusterRepositoryEvent(event.getRepository().getURI().toString(), event.getType());
                    clusterRepositoryEvent.setSourceGroup(group);
                    clusterRepositoryEvent.setSourceNode(this.clusterManager.getNode());
                    clusterRepositoryEvent.setLocal(this.clusterManager.getNode());
                    clusterRepositoryEvent.setInstall(false);
                    clusterRepositoryEvent.setUninstall(false);
                    clusterRepositoryEvent.setRefresh(false);
                    RepositoryEvent.EventType type = event.getType();
                    Map clusterRepositories = this.clusterManager.getMap("org.apache.karaf.cellar.repositories." + group.getName());
                    if (RepositoryEvent.EventType.RepositoryAdded.equals((Object)type)) {
                        if (!clusterRepositories.containsKey(event.getRepository().getURI().toString())) {
                            try {
                                clusterRepositories.put(event.getRepository().getURI().toString(), event.getRepository().getName());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + group.getName());
                        try {
                            for (Feature feature : event.getRepository().getFeatures()) {
                                FeatureState clusterFeatureState = new FeatureState();
                                clusterFeatureState.setName(feature.getName());
                                clusterFeatureState.setVersion(feature.getVersion());
                                clusterFeatureState.setInstalled(Boolean.FALSE);
                                clusterFeatures.put(feature.getName() + "/" + feature.getVersion(), clusterFeatureState);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("CELLAR FEATURE: failed to update the cluster group", (Throwable)e);
                        }
                    } else {
                        clusterRepositories.remove(event.getRepository().getURI().toString());
                        clusterFeatures = this.clusterManager.getMap("org.apache.karaf.cellar.features." + group.getName());
                        try {
                            for (Feature feature : event.getRepository().getFeatures()) {
                                clusterFeatures.remove(feature.getName() + "/" + feature.getVersion());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.warn("CELLAR FEATURE: failed to update the cluster group", (Throwable)e);
                        }
                    }
                    this.eventProducer.produce((Event)clusterRepositoryEvent);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private boolean isEnabled() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null) {
                String value = properties.get("feature.listener").toString();
                return Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR FEATURE: can't check listener configuration", (Throwable)e);
        }
        return false;
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

