/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.config;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.karaf.cellar.config.ClusterConfigurationEvent;
import org.apache.karaf.cellar.config.ConfigurationSupport;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventType;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConfigurationListener
extends ConfigurationSupport
implements ConfigurationListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(LocalConfigurationListener.class);
    private EventProducer eventProducer;

    public void configurationEvent(ConfigurationEvent event) {
        if (!this.isEnabled()) {
            LOGGER.trace("CELLAR CONFIG: local listener is disabled");
            return;
        }
        if (this.eventProducer.getSwitch().getStatus().equals((Object)SwitchStatus.OFF)) {
            LOGGER.debug("CELLAR CONFIG: cluster event producer is OFF");
            return;
        }
        String pid = event.getPid();
        Set groups = this.groupManager.listLocalGroups();
        if (groups != null && !groups.isEmpty()) {
            for (Group group : groups) {
                if (this.isAllowed(group, "config", pid, EventType.OUTBOUND).booleanValue()) {
                    Map clusterConfigurations = this.clusterManager.getMap("org.apache.karaf.cellar.configuration.map." + group.getName());
                    try {
                        Properties distributedDictionary;
                        if (event.getType() == 2) {
                            if (!clusterConfigurations.containsKey(pid)) continue;
                            String filename = (String)((Properties)clusterConfigurations.get(pid)).get("karaf.cellar.filename");
                            ArrayList matchingPids = new ArrayList();
                            for (Map.Entry entry : clusterConfigurations.entrySet()) {
                                if (!filename.equals(((Properties)entry.getValue()).get("karaf.cellar.filename"))) continue;
                                matchingPids.add(entry.getKey());
                            }
                            for (String matchingPid : matchingPids) {
                                clusterConfigurations.put(matchingPid, this.getDeletedConfigurationMarker((Dictionary)clusterConfigurations.get(matchingPid)));
                            }
                            ClusterConfigurationEvent clusterConfigurationEvent = new ClusterConfigurationEvent(pid);
                            clusterConfigurationEvent.setType(event.getType());
                            clusterConfigurationEvent.setSourceNode(this.clusterManager.getNode());
                            clusterConfigurationEvent.setSourceGroup(group);
                            clusterConfigurationEvent.setLocal(this.clusterManager.getNode());
                            this.eventProducer.produce((Event)clusterConfigurationEvent);
                            continue;
                        }
                        Configuration conf = this.configurationAdmin.getConfiguration(pid, null);
                        Dictionary localDictionary = conf.getProperties();
                        if (this.equals(localDictionary = this.filter(localDictionary), distributedDictionary = (Properties)clusterConfigurations.get(pid)) || !this.canDistributeConfig(localDictionary)) continue;
                        clusterConfigurations.put(pid, LocalConfigurationListener.dictionaryToProperties(localDictionary));
                        ClusterConfigurationEvent clusterConfigurationEvent = new ClusterConfigurationEvent(pid);
                        clusterConfigurationEvent.setSourceGroup(group);
                        clusterConfigurationEvent.setSourceNode(this.clusterManager.getNode());
                        clusterConfigurationEvent.setLocal(this.clusterManager.getNode());
                        this.eventProducer.produce((Event)clusterConfigurationEvent);
                    }
                    catch (Exception e) {
                        LOGGER.error("CELLAR CONFIG: failed to update configuration with PID {} in the cluster group {}", new Object[]{pid, group.getName(), e});
                    }
                    continue;
                }
                LOGGER.trace("CELLAR CONFIG: configuration with PID {} is marked BLOCKED OUTBOUND for cluster group {}", (Object)pid, (Object)group.getName());
            }
        }
    }

    private boolean isEnabled() {
        try {
            Configuration configuration = this.configurationAdmin.getConfiguration("org.apache.karaf.cellar.node", null);
            Dictionary properties = configuration.getProperties();
            if (properties != null) {
                String value = properties.get("config.listener").toString();
                return Boolean.parseBoolean(value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("CELLAR CONFIG: can't check listener configuration", (Throwable)e);
        }
        return false;
    }

    public void init() {
    }

    public void destroy() {
    }

    public EventProducer getEventProducer() {
        return this.eventProducer;
    }

    public void setEventProducer(EventProducer eventProducer) {
        this.eventProducer = eventProducer;
    }
}

