/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.analysis;

import com.strobel.assembler.metadata.IMetadataTypeMember;
import com.strobel.decompiler.ast.Variable;
import com.strobel.decompiler.languages.java.analysis.UsageClassifier;
import com.strobel.decompiler.languages.java.analysis.UsageType;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IdentifierExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.utilities.TreeTraversal;
import com.strobel.functions.Function;
import java.util.Collection;
import java.util.LinkedHashSet;

public final class Correlator {
    public static boolean areCorrelated(Expression readExpression, Statement writeStatement) {
        LinkedHashSet<IMetadataTypeMember> readMembers = new LinkedHashSet<IMetadataTypeMember>();
        LinkedHashSet<IMetadataTypeMember> writeMembers = new LinkedHashSet<IMetadataTypeMember>();
        Correlator.collectCorrelations(readExpression, CorrelationMode.Read, readMembers);
        if (readMembers.isEmpty()) {
            return false;
        }
        Correlator.collectCorrelations(writeStatement, CorrelationMode.Write, writeMembers);
        if (writeMembers.isEmpty()) {
            return false;
        }
        for (IMetadataTypeMember typeMember : readMembers) {
            if (!writeMembers.contains(typeMember)) continue;
            return true;
        }
        return false;
    }

    private static void collectCorrelations(AstNode node, CorrelationMode mode, Collection<IMetadataTypeMember> members) {
        Iterable<AstNode> traversal = TreeTraversal.postOrder(node, new Function<AstNode, Iterable<AstNode>>(){

            public Iterable<AstNode> apply(AstNode n) {
                return n.getChildren();
            }
        });
        for (AstNode n : traversal) {
            if (!(n instanceof IdentifierExpression)) continue;
            IdentifierExpression identifier = (IdentifierExpression)n;
            UsageType usage = UsageClassifier.getUsageType(identifier);
            if (mode != CorrelationMode.Read ? usage != UsageType.Write && usage != UsageType.ReadWrite : usage != UsageType.Read && usage != UsageType.ReadWrite) continue;
            IMetadataTypeMember member = identifier.getUserData(Keys.MEMBER_REFERENCE);
            if (member != null) {
                members.add(member);
                continue;
            }
            Variable variable = identifier.getUserData(Keys.VARIABLE);
            if (variable == null) continue;
            if (variable.isParameter()) {
                member = variable.getOriginalParameter();
            } else if (variable.getOriginalVariable() != null) {
                member = variable.getOriginalVariable();
            }
            if (member == null) continue;
            members.add(member);
        }
    }

    private static enum CorrelationMode {
        Read,
        Write;

    }
}

