/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex5;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.RoomNumber;
import org.apache.uima.util.Level;

public class RoomNumberAnnotator
extends JCasAnnotator_ImplBase {
    private Pattern[] mPatterns;
    private String[] mLocations;
    public static final String MESSAGE_DIGEST = "org.apache.uima.tutorial.ex5.RoomNumberAnnotator_Messages";

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String[] patternStrings = (String[])aContext.getConfigParameterValue("Patterns");
        this.mLocations = (String[])aContext.getConfigParameterValue("Locations");
        this.mPatterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                this.mPatterns[i] = Pattern.compile(patternStrings[i]);
                continue;
            }
            catch (PatternSyntaxException e) {
                throw new ResourceInitializationException(MESSAGE_DIGEST, "regex_syntax_error", new Object[]{patternStrings[i]}, (Throwable)e);
            }
        }
    }

    public void process(JCas aJCas) {
        String docText = aJCas.getDocumentText();
        for (int i = 0; i < this.mPatterns.length; ++i) {
            Matcher matcher = this.mPatterns[i].matcher(docText);
            while (matcher.find()) {
                RoomNumber annotation = new RoomNumber(aJCas);
                annotation.setBegin(matcher.start());
                annotation.setEnd(matcher.end());
                annotation.addToIndexes();
                annotation.setBuilding(this.mLocations[i]);
                this.getContext().getLogger().log(Level.FINEST, "Found: " + (Object)((Object)annotation));
            }
        }
    }
}

