/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.service.impl.AnalysisEngineService_impl;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.service.impl.ResourceService_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;

public class AxisResourceServiceManager {
    public static final String PARAM_RESOURCE_SPECIFIER_PATH = "resourceSpecifierPath";
    public static final String PARAM_NUM_INSTANCES = "numInstances";
    public static final String PARAM_ENABLE_LOGGING = "enableLogging";
    private static Map mResourceServiceImplMap = new HashMap();

    public static ResourceService_impl getServiceImpl(Class aServiceImplClass) throws AxisFault {
        try {
            int numInstances;
            MessageContext ctx = MessageContext.getCurrentContext();
            if (ctx == null) {
                throw new Exception("MessageContext = NULL");
            }
            SOAPService self = ctx.getService();
            if (self == null) {
                throw new Exception("Handler = NULL");
            }
            String serviceName = self.getName();
            ResourceService_impl serviceImpl = (ResourceService_impl)mResourceServiceImplMap.get(serviceName);
            if (serviceImpl != null) {
                return serviceImpl;
            }
            String resourceSpecifierPath = (String)self.getOption(PARAM_RESOURCE_SPECIFIER_PATH);
            if (resourceSpecifierPath == null || resourceSpecifierPath.trim().length() == 0) {
                throw new Exception("Invalid Configuration - resourceSpecifierPath not Defined.  Check your deployment descriptor file (WSDD)");
            }
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(resourceSpecifierPath));
            String numInstancesStr = (String)self.getOption(PARAM_NUM_INSTANCES);
            try {
                numInstances = Integer.parseInt(numInstancesStr);
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid Configuration - numInstances not valid.  Check your deployment descriptor file (WSDD)");
            }
            String enableLogStr = (String)self.getOption(PARAM_ENABLE_LOGGING);
            boolean enableLog = "true".equalsIgnoreCase(enableLogStr);
            serviceImpl = (ResourceService_impl)aServiceImplClass.newInstance();
            HashMap<String, Integer> initParams = new HashMap<String, Integer>();
            initParams.put("NUM_SIMULTANEOUS_REQUESTS", new Integer(numInstances));
            serviceImpl.initialize(resourceSpecifier, initParams);
            if (!enableLog && serviceImpl instanceof AnalysisEngineService_impl) {
                Logger nullLogger = UIMAFramework.newLogger();
                nullLogger.setOutputStream(null);
                ((AnalysisEngineService_impl)serviceImpl).getAnalysisEngine().setLogger(nullLogger);
            }
            mResourceServiceImplMap.put(serviceName, serviceImpl);
            return serviceImpl;
        }
        catch (Exception e) {
            UIMAFramework.getLogger().log(Level.SEVERE, e.getMessage(), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }
}

