/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.tools.cpm.MetaDataPanel;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class ConsumerPanel
extends MetaDataPanel {
    private static final long serialVersionUID = -6822046781435538398L;
    ResourceSpecifier casConsumerSpecifier;
    File specifierFile;
    long lastFileSyncTimestamp;

    public ConsumerPanel(ResourceSpecifier casConsumerSpecifier, File specifierFile, long fileModStamp) {
        super(4);
        this.casConsumerSpecifier = casConsumerSpecifier;
        this.specifierFile = specifierFile;
        this.lastFileSyncTimestamp = fileModStamp;
    }

    public ResourceSpecifier getCasConsumerSpecifier() {
        return this.casConsumerSpecifier;
    }

    public long getLastFileSyncTimestamp() {
        return this.lastFileSyncTimestamp;
    }

    public void setLastFileSyncTimestamp(long timestamp) {
        this.lastFileSyncTimestamp = timestamp;
    }

    public boolean hasFileChanged(long lastCheck) {
        return this.specifierFile.lastModified() > this.lastFileSyncTimestamp && this.specifierFile.lastModified() > lastCheck;
    }

    public void refreshFromFile() throws InvalidXMLException, IOException {
        this.clearAll();
        this.casConsumerSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(this.specifierFile));
        if (this.casConsumerSpecifier instanceof CasConsumerDescription) {
            CasConsumerDescription consumerDescription = (CasConsumerDescription)this.casConsumerSpecifier;
            this.populate(consumerDescription.getMetaData(), null);
        }
        this.lastFileSyncTimestamp = this.specifierFile.lastModified();
    }
}

