/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.util;

import java.util.Arrays;
import org.apache.uima.caseditor.editor.util.IDGenerator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ObjectTransfer
extends ByteArrayTransfer {
    private IDGenerator mIdGenerator = IDGenerator.getInstance();
    private String mTransferName;
    private int mTransferID;
    private byte[] mCurrentID;
    private Object mObject;

    protected ObjectTransfer(String name) {
        this.mTransferName = name;
        this.mTransferID = ObjectTransfer.registerType((String)this.mTransferName);
    }

    protected void javaToNative(Object object, TransferData transferData) {
        this.mCurrentID = this.mIdGenerator.nextUniqueID();
        this.mObject = object;
        if (transferData != null) {
            super.javaToNative((Object)this.mCurrentID, transferData);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        return Arrays.equals(this.mCurrentID, bytes) ? this.mObject : null;
    }

    protected int[] getTypeIds() {
        return new int[]{this.mTransferID};
    }

    protected String[] getTypeNames() {
        return new String[]{this.mTransferName};
    }
}

