/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.tools.cvd.ArrayNode;
import org.apache.uima.tools.cvd.FSNode;
import org.apache.uima.tools.cvd.FSTreeNode;

public class FSTreeModel
implements TreeModel {
    private FSTreeNode root;
    private CASImpl cas;
    private List<TreeModelListener> treeModelListeners = new ArrayList<TreeModelListener>();
    private List<FSNode> fss;
    private static final String defaultRootString = "<html><b><font color=#808080>FS List - no selection</b></html>";
    private String rootString = "<html><b><font color=#808080>FS List - no selection</b></html>";

    public FSTreeModel() {
        this.root = new FSNode(this, 5, 0L, null);
        this.root.setChildren(new ArrayList<FSTreeNode>());
    }

    public void update(String indexName, FSIndex index, CAS cas1) {
        this.cas = (CASImpl)cas1;
        int size = index.size();
        this.rootString = "<html><font color=green>" + indexName + "</font> - <font color=blue>" + index.getType().getName() + "</font> [" + size + "]</html>";
        this.root = new FSNode(this, 5, 0L, null);
        this.fss = new ArrayList<FSNode>();
        FSIterator it = index.iterator();
        int count = 0;
        it.moveToFirst();
        while (it.isValid()) {
            FeatureStructure fs = it.get();
            this.fss.add(new FSNode(this, this.getNodeType(fs.getType()), (long)fs.hashCode(), count));
            ++count;
            it.moveToNext();
        }
        List<FSTreeNode> kids = FSTreeModel.createArrayChildren(0, size, this.fss, this);
        this.root.setChildren(kids);
        Object[] path = new Object[]{this.root};
        TreeModelEvent event = new TreeModelEvent((Object)this.root, path);
        for (int i = 0; i < this.treeModelListeners.size(); ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    public void reset() {
        this.root.removeAllChildren();
        this.rootString = defaultRootString;
        Object[] path = new Object[]{this.root};
        TreeModelEvent event = new TreeModelEvent((Object)this.root, path);
        for (int i = 0; i < this.treeModelListeners.size(); ++i) {
            this.treeModelListeners.get(i).treeStructureChanged(event);
        }
    }

    public List<FSNode> getFSs() {
        return this.fss;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        FSTreeNode node = (FSTreeNode)parent;
        node.initChildren();
        return node.getChildren().get(index);
    }

    int getNodeType(int addr, Feature feat) {
        Type domType = feat.getRange();
        if (this.cas.isStringType(domType)) {
            return 2;
        }
        if (this.cas.isIntType(domType)) {
            return 0;
        }
        if (this.cas.isFloatType(domType)) {
            return 1;
        }
        if (this.cas.isByteType(domType)) {
            return 6;
        }
        if (this.cas.isBooleanType(domType)) {
            return 7;
        }
        if (this.cas.isShortType(domType)) {
            return 8;
        }
        if (this.cas.isLongType(domType)) {
            return 9;
        }
        if (this.cas.isDoubleType(domType)) {
            return 10;
        }
        if (this.cas.isAbstractArrayType(domType)) {
            int featAddr = this.cas.getFeatureValue(addr, ((FeatureImpl)feat).getCode());
            if (this.cas.isArrayType(this.cas.getTypeSystemImpl().ll_getTypeForCode(this.cas.getHeapValue(featAddr)))) {
                return 3;
            }
        }
        return 4;
    }

    int getNodeType(Type type) {
        if (this.cas.isStringType(type)) {
            return 2;
        }
        if (this.cas.isIntType(type)) {
            return 0;
        }
        if (this.cas.isFloatType(type)) {
            return 1;
        }
        if (this.cas.isArrayType(type)) {
            return 3;
        }
        if (this.cas.isByteArrayType(type)) {
            return 6;
        }
        if (this.cas.isBooleanArrayType(type)) {
            return 7;
        }
        if (this.cas.isShortArrayType(type)) {
            return 8;
        }
        if (this.cas.isLongArrayType(type)) {
            return 9;
        }
        if (this.cas.isDoubleArrayType(type)) {
            return 10;
        }
        return 4;
    }

    @Override
    public int getChildCount(Object parent) {
        return ((FSTreeNode)parent).getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        FSTreeNode node = (FSTreeNode)parent;
        node.initChildren();
        return node.getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
        this.treeModelListeners.add(arg0);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
        this.treeModelListeners.remove(arg0);
    }

    CASImpl getCas() {
        return this.cas;
    }

    String getRootString() {
        return this.rootString;
    }

    static List<FSTreeNode> createArrayChildren(int start, int end, List<FSNode> array, FSTreeModel model) {
        ArrayList<FSTreeNode> kids = new ArrayList<FSTreeNode>();
        int size = end - start;
        if (size <= 100) {
            kids.ensureCapacity(size);
            for (int i = start; i < end; ++i) {
                kids.add(array.get(i));
            }
        } else {
            ArrayNode node;
            int deg = ArrayNode.degree(size);
            int divisor = (int)Math.pow(10.0, deg);
            int buckets = size / divisor;
            int rem = size % divisor;
            for (int i = 0; i < buckets; ++i) {
                int start_i = start + i * divisor;
                int end_i = start_i + divisor;
                node = new ArrayNode(start_i, end_i - 1);
                List<FSTreeNode> grandkids = FSTreeModel.createArrayChildren(start_i, end_i, array, model);
                node.setChildren(grandkids);
                kids.add(node);
            }
            if (rem > 0) {
                int start_rem = start + buckets * divisor;
                if (rem <= 100) {
                    for (int i = start_rem; i < end; ++i) {
                        kids.add(array.get(i));
                    }
                } else {
                    node = new ArrayNode(start_rem, end - 1);
                    node.setChildren(FSTreeModel.createArrayChildren(start_rem, end, array, model));
                    kids.add(node);
                }
            }
        }
        return kids;
    }

    public TreePath pathToNode(int fsNum) {
        ArrayList<FSTreeNode> p = new ArrayList<FSTreeNode>();
        p.add(this.root);
        this.getPathToNode(fsNum, this.root.getChildren(), p);
        TreePath path = new TreePath(p.toArray());
        return path;
    }

    private void getPathToNode(int n, List<FSTreeNode> dtrs, List<FSTreeNode> path) {
        for (int i = 0; i < dtrs.size(); ++i) {
            FSTreeNode node = dtrs.get(i);
            if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                if (arrayNode.getEnd() < n) continue;
                path.add(node);
                this.getPathToNode(n, node.getChildren(), path);
                return;
            }
            FSNode fsNode = (FSNode)node;
            if (fsNode.getArrayPos() != n) continue;
            path.add(node);
            return;
        }
    }
}

