/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class ValidateDescriptor {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: java " + ValidateDescriptor.class.getName() + " <descriptor file>");
            System.exit(1);
        }
        System.out.println("Parsing...");
        try {
            XMLizable desc = UIMAFramework.getXMLParser().parse(new XMLInputSource(args[0]));
            if (desc instanceof ResourceCreationSpecifier) {
                System.out.println("Validating...");
                ((ResourceCreationSpecifier)desc).doFullValidation();
                System.out.println("Descriptor is valid.");
            } else {
                System.err.println("This type of descriptor is not supported by this tool.");
            }
        }
        catch (UIMA_IllegalStateException e) {
            System.err.println("This type of descriptor is not supported by this tool.");
        }
        catch (Exception e) {
            System.err.println("Descriptor is invalid.");
            e.printStackTrace();
        }
    }
}

