/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer.socket;

import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.base_cpm.CasProcessor;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.base_cpm.container.ProcessingContainer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeployer;
import org.apache.uima.collection.impl.base_cpm.container.deployer.CasProcessorDeploymentException;
import org.apache.uima.collection.impl.cpm.container.CPEFactory;
import org.apache.uima.collection.impl.cpm.container.CasObjectNetworkCasProcessorImpl;
import org.apache.uima.collection.impl.cpm.container.CasProcessorConfigurationJAXBImpl;
import org.apache.uima.collection.impl.cpm.container.ProcessingContainer_Impl;
import org.apache.uima.collection.impl.cpm.container.ServiceProxyPool;
import org.apache.uima.collection.impl.cpm.container.deployer.socket.ProcessControllerAdapter;
import org.apache.uima.collection.impl.cpm.engine.CPMEngine;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;

public class SocketCasProcessorDeployer
implements CasProcessorDeployer {
    private CPEFactory cpeFactory = null;
    private URL[] serviceUrls = null;
    private ProcessControllerAdapter controller = null;

    public SocketCasProcessorDeployer(ProcessControllerAdapter aController, CPEFactory aCpeFactory) {
        this.controller = aController;
        this.cpeFactory = aCpeFactory;
    }

    public SocketCasProcessorDeployer(ProcessControllerAdapter aController) {
        this.controller = aController;
    }

    public ProcessingContainer deployCasProcessor(List aCasProcessorList, CPMEngine aEngine, boolean redeploy) throws ResourceConfigurationException {
        return this.deployCasProcessor(aCasProcessorList, redeploy);
    }

    @Override
    public ProcessingContainer deployCasProcessor(List aCasProcessorList, boolean redeploy) throws ResourceConfigurationException {
        String name = null;
        CasProcessor cProcessor = null;
        CasProcessorConfiguration casProcessorConfig = null;
        ProcessingContainer processingContainer = null;
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploy_services__FINEST", (Object)Thread.currentThread().getName());
        }
        if (this.controller == null) {
            throw new ResourceConfigurationException("config_setting_absent", new Object[]{"ProcessControllerAdapter"});
        }
        try {
            this.serviceUrls = this.controller.deploy(name, aCasProcessorList.size());
            ServiceProxyPool casProcessorPool = new ServiceProxyPool();
            for (int i = 0; i < aCasProcessorList.size(); ++i) {
                cProcessor = (CasProcessor)aCasProcessorList.get(i);
                if (processingContainer == null) {
                    ProcessingResourceMetaData metaData = cProcessor.getProcessingResourceMetaData();
                    CpeCasProcessor casProcessorType = (CpeCasProcessor)this.cpeFactory.casProcessorConfigMap.get(metaData.getName());
                    casProcessorConfig = new CasProcessorConfigurationJAXBImpl(casProcessorType, this.cpeFactory.getResourceManager());
                    processingContainer = new ProcessingContainer_Impl(casProcessorConfig, metaData, casProcessorPool);
                    processingContainer.setCasProcessorDeployer(this);
                    processingContainer.setSingleFencedService(true);
                    name = casProcessorConfig.getName();
                    if (name == null) {
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unable_to_read_meta__SEVERE", (Object)Thread.currentThread().getName());
                        }
                        throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_casprocessor_no_name_found__SEVERE", new Object[]{Thread.currentThread().getName()});
                    }
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploying_service__FINEST", new Object[]{Thread.currentThread().getName(), name});
                }
                if (cProcessor instanceof CasObjectNetworkCasProcessorImpl) {
                    ((CasObjectNetworkCasProcessorImpl)cProcessor).connect(this.serviceUrls[i]);
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_deployed__FINEST", new Object[]{Thread.currentThread().getName(), name});
                    }
                }
                casProcessorPool.addCasProcessor(cProcessor);
            }
            if (processingContainer == null) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_invalid_container__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
            casProcessorConfig = processingContainer.getCasProcessorConfiguration();
            if (casProcessorConfig == null) {
                throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_container_configuration_not_found__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
        }
        catch (ResourceConfigurationException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            throw new ResourceConfigurationException((Throwable)e);
        }
        return processingContainer;
    }

    @Override
    public void deployCasProcessor(ProcessingContainer aProcessingContainer) throws ResourceConfigurationException {
        try {
            if (aProcessingContainer.isSingleFencedService()) {
                ServiceProxyPool pool = aProcessingContainer.getPool();
                if (pool == null) {
                    if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_service_proxy__SEVERE", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
                    }
                    throw new ResourceConfigurationException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_service_proxy__SEVERE", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
                }
                int totalPoolSize = pool.getAllInstanceCount();
                while (totalPoolSize != pool.getSize()) {
                    try {
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_wait_for_service_proxy_pool__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
                        }
                        pool.wait();
                    }
                    catch (Exception exception) {}
                }
                CasProcessor cProcessor = pool.checkOut();
                if (cProcessor != null && cProcessor instanceof CasObjectNetworkCasProcessorImpl) {
                    URL undeployUrl = ((CasObjectNetworkCasProcessorImpl)cProcessor).getEndpoint();
                    this.undeploy(undeployUrl);
                    pool.checkIn(cProcessor);
                    cProcessor = null;
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deploying_service__FINEST", new Object[]{Thread.currentThread().getName(), aProcessingContainer.getName()});
                    }
                    this.serviceUrls = this.controller.deploy(aProcessingContainer.getName(), totalPoolSize);
                    LinkedList<CasProcessor> casProcessors = new LinkedList<CasProcessor>();
                    try {
                        for (int i = 0; i < totalPoolSize; ++i) {
                            cProcessor = pool.checkOut();
                            ((CasObjectNetworkCasProcessorImpl)cProcessor).connect(this.serviceUrls[i]);
                            casProcessors.add(cProcessor);
                        }
                    }
                    catch (Exception e) {
                        if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                            UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        while (casProcessors.size() > 0) {
                            cProcessor = (CasProcessor)casProcessors.remove(0);
                            pool.checkIn(cProcessor);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            throw new ResourceConfigurationException((Throwable)e);
        }
    }

    @Override
    public void undeploy(URL aURL) throws CasProcessorDeploymentException {
        try {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_undeploying_service__FINEST", new Object[]{Thread.currentThread().getName(), aURL.getHost(), String.valueOf(aURL.getPort())});
            }
            this.controller.undeploy(aURL);
        }
        catch (Exception e) {
            throw new CasProcessorDeploymentException(e);
        }
    }

    @Override
    public void undeploy() throws CasProcessorDeploymentException {
        try {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "Undeploying CasProcessor");
            }
            for (int i = 0; i < this.serviceUrls.length; ++i) {
                this.controller.undeploy(this.serviceUrls[i]);
            }
        }
        catch (Exception e) {
            throw new CasProcessorDeploymentException(e);
        }
    }
}

