/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor.styleview;

import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.Images;
import org.apache.uima.caseditor.editor.AnnotationEditor;
import org.apache.uima.caseditor.editor.AnnotationStyle;
import org.apache.uima.caseditor.editor.AnnotationStyleChangeListener;
import org.apache.uima.caseditor.editor.IAnnotationEditorModifyListener;
import org.apache.uima.caseditor.editor.styleview.AnnotationTypeNode;
import org.apache.uima.caseditor.ui.property.EditorAnnotationPropertyPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.part.Page;

class AnnotationStyleViewPage
extends Page {
    private AnnotationEditor editor;
    private IAnnotationEditorModifyListener editorListener;
    private AnnotationStyleChangeListener changeListener;
    private CheckboxTableViewer treeViewer;

    AnnotationStyleViewPage(AnnotationEditor editor) {
        this.editor = editor;
    }

    private static AnnotationTypeNode[] typesToNodes(Collection<Type> types, AnnotationEditor editor) {
        Collection<Type> shownTypes = editor.getShownAnnotationTypes();
        AnnotationTypeNode[] selectedNodes = new AnnotationTypeNode[shownTypes.size()];
        int typeIndex = 0;
        for (Type shownType : shownTypes) {
            selectedNodes[typeIndex++] = new AnnotationTypeNode(editor, shownType);
        }
        return selectedNodes;
    }

    public void createControl(Composite parent) {
        Table table = new Table(parent, 527136);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        final Color defaultForegroundColor = table.getForeground();
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0) {
                    event.detail &= 0xFFFFFFFD;
                    event.gc.setForeground(defaultForegroundColor);
                }
            }
        });
        this.treeViewer = new CheckboxTableViewer(table);
        TableColumn typeColumn = new TableColumn(table, 16384);
        typeColumn.setAlignment(16384);
        typeColumn.setText("Type");
        typeColumn.setWidth(120);
        TableColumn stlyeColumn = new TableColumn(table, 16384);
        stlyeColumn.setAlignment(16384);
        stlyeColumn.setText("Style");
        stlyeColumn.setWidth(100);
        this.treeViewer.setContentProvider((IContentProvider)new AnnotationTypeContentProvider(this.editor));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AnnotationStylingLabelProvider(this.editor));
        this.treeViewer.setInput((Object)this.editor.getDocument().getCAS().getTypeSystem());
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.changeListener = new AnnotationStyleChangeListener(){

            @Override
            public void annotationStylesChanged(Collection<AnnotationStyle> styles) {
                Object[] typeNodes = new AnnotationTypeNode[styles.size()];
                int i = 0;
                for (AnnotationStyle style : styles) {
                    typeNodes[i++] = new AnnotationTypeNode(AnnotationStyleViewPage.this.editor, AnnotationStyleViewPage.this.editor.getDocument().getType(style.getAnnotation()));
                }
                AnnotationStyleViewPage.this.treeViewer.update(typeNodes, null);
            }
        };
        this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore(this.editor.getEditorInput()).addPropertyChangeListener((IPropertyChangeListener)this.changeListener);
        this.treeViewer.setCheckedElements((Object[])AnnotationStyleViewPage.typesToNodes(this.editor.getShownAnnotationTypes(), this.editor));
        this.treeViewer.setGrayed((Object)new AnnotationTypeNode(this.editor, this.editor.getAnnotationMode()), true);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AnnotationTypeNode typeNode = (AnnotationTypeNode)event.getElement();
                if (typeNode.getAnnotationType().equals(AnnotationStyleViewPage.this.editor.getAnnotationMode())) {
                    AnnotationStyleViewPage.this.treeViewer.setChecked(event.getElement(), true);
                } else {
                    AnnotationStyleViewPage.this.editor.setShownAnnotationType(typeNode.getAnnotationType(), event.getChecked());
                }
            }
        });
        this.editorListener = new IAnnotationEditorModifyListener(){

            @Override
            public void showAnnotationsChanged(Collection<Type> shownAnnotationTypes) {
                AnnotationStyleViewPage.this.treeViewer.setCheckedElements((Object[])AnnotationStyleViewPage.typesToNodes(shownAnnotationTypes, AnnotationStyleViewPage.this.editor));
            }

            @Override
            public void annotationModeChanged(Type newMode) {
                AnnotationStyleViewPage.this.treeViewer.setAllGrayed(false);
                AnnotationStyleViewPage.this.treeViewer.setGrayed((Object)new AnnotationTypeNode(AnnotationStyleViewPage.this.editor, newMode), true);
            }
        };
        this.editor.addAnnotationListener(this.editorListener);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        super.makeContributions(menuManager, toolBarManager, statusLineManager);
        Action action = new Action(){

            public void run() {
                super.run();
                StructuredSelection sel = new StructuredSelection((Object)new AnnotationTypeNode(AnnotationStyleViewPage.this.editor, null));
                EditorAnnotationPropertyPage page = new EditorAnnotationPropertyPage();
                page.setElement(new AnnotationTypeNode(AnnotationStyleViewPage.this.editor, null));
                page.setTitle("Styles");
                PreferenceManager mgr = new PreferenceManager();
                PreferenceNode node = new PreferenceNode("1", (IPreferencePage)page);
                mgr.addToRoot((IPreferenceNode)node);
                PropertyDialog dialog = new PropertyDialog(AnnotationStyleViewPage.this.getSite().getShell(), mgr, (ISelection)sel);
                dialog.create();
                dialog.setMessage(page.getTitle());
                dialog.open();
            }
        };
        action.setImageDescriptor(CasEditorPlugin.getTaeImageDescriptor(Images.MODEL_PROCESSOR_FOLDER));
        toolBarManager.add((IAction)action);
    }

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        IPreferenceStore store = this.editor.getCasDocumentProvider().getTypeSystemPreferenceStore(this.editor.getEditorInput());
        if (store != null && this.changeListener != null) {
            store.removePropertyChangeListener((IPropertyChangeListener)this.changeListener);
        }
        this.editor.removeAnnotationListener(this.editorListener);
    }

    static class AnnotationStylingLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private static int TYPE_NAME_COLUMN = 0;
        private static int STYLE_NAME_COLUMN = 1;
        private AnnotationEditor editor;

        AnnotationStylingLabelProvider(AnnotationEditor editor) {
            this.editor = editor;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            AnnotationTypeNode typeNode = (AnnotationTypeNode)element;
            Type type = typeNode.getAnnotationType();
            AnnotationStyle style = this.editor.getAnnotationStyle(type);
            if (TYPE_NAME_COLUMN == columnIndex) {
                return type.getShortName().trim();
            }
            if (STYLE_NAME_COLUMN == columnIndex) {
                return style.getStyle().toString();
            }
            throw new IllegalStateException("Unkown column!");
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Color getBackground(Object element) {
            AnnotationTypeNode typeNode = (AnnotationTypeNode)element;
            Type type = typeNode.getAnnotationType();
            AnnotationStyle style = this.editor.getAnnotationStyle(type);
            return new Color((Device)Display.getCurrent(), style.getColor().getRed(), style.getColor().getGreen(), style.getColor().getBlue());
        }
    }

    static class AnnotationTypeContentProvider
    implements ITreeContentProvider {
        private AnnotationTypeNode[] annotationTypes;
        private AnnotationEditor editor;

        AnnotationTypeContentProvider(AnnotationEditor editor) {
            this.editor = editor;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof TypeSystem) {
                TypeSystem ts = (TypeSystem)newInput;
                List annotationTypeList = ts.getProperlySubsumedTypes(ts.getType("uima.tcas.Annotation"));
                annotationTypeList.add(ts.getType("uima.tcas.Annotation"));
                this.annotationTypes = new AnnotationTypeNode[annotationTypeList.size()];
                for (int i = 0; i < annotationTypeList.size(); ++i) {
                    this.annotationTypes[i] = new AnnotationTypeNode(this.editor, (Type)annotationTypeList.get(i));
                }
            } else {
                this.annotationTypes = null;
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.annotationTypes;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

