/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.rb_trees.Int2IntRBT;

public class CasSeqAddrMaps {
    private final IntVector tgtSeq2SrcAddr;
    private final Int2IntRBT srcAddr2TgtSeq;
    private int nextTgt = 0;

    public CasSeqAddrMaps() {
        this.tgtSeq2SrcAddr = new IntVector();
        this.srcAddr2TgtSeq = new Int2IntRBT();
        this.addItemAddr(0, 0, true);
    }

    public CasSeqAddrMaps(IntVector tgtSeq2SrcAddr, Int2IntRBT srcAddr2TgtSeq) {
        this.tgtSeq2SrcAddr = tgtSeq2SrcAddr;
        this.srcAddr2TgtSeq = srcAddr2TgtSeq;
    }

    public void addItemAddr(int srcAddr, int tgtAddr, boolean inTarget) {
        int n;
        if (inTarget) {
            this.tgtSeq2SrcAddr.add(srcAddr);
        }
        if (inTarget) {
            int n2 = this.nextTgt;
            n = n2;
            this.nextTgt = n2 + 1;
        } else {
            n = -1;
        }
        this.srcAddr2TgtSeq.put(srcAddr, n);
    }

    public void addSrcAddrForTgt(int srcAddr, boolean inSrc) {
        if (inSrc) {
            this.srcAddr2TgtSeq.put(srcAddr, this.nextTgt);
            this.tgtSeq2SrcAddr.add(srcAddr);
        } else {
            this.tgtSeq2SrcAddr.add(0);
        }
        ++this.nextTgt;
    }

    public int getSrcAddrFromTgtSeq(int seq) {
        return this.tgtSeq2SrcAddr.get(seq);
    }

    public int getTgtSeqFromSrcAddr(int itemAddr) {
        return this.srcAddr2TgtSeq.getMostlyClose(itemAddr);
    }

    public int getNumberSrcFss() {
        return this.srcAddr2TgtSeq.size();
    }

    CasSeqAddrMaps copy() {
        CasSeqAddrMaps c = new CasSeqAddrMaps(this.tgtSeq2SrcAddr.copy(), this.srcAddr2TgtSeq.copy());
        c.nextTgt = this.nextTgt;
        return c;
    }
}

