/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.tools.cvd.MainFrame;

public class XCASFileOpenEventHandler
implements ActionListener {
    private final MainFrame main;

    public XCASFileOpenEventHandler(MainFrame frame) {
        this.main = frame;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        File xcasFile;
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open XCAS file");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showOpenDialog(this.main)) == 0 && (xcasFile = fileChooser.getSelectedFile()).exists() && xcasFile.isFile()) {
            try {
                this.main.setXcasFileOpenDir(xcasFile.getParentFile());
                Timer time = new Timer();
                time.start();
                SAXParserFactory saxParserFactory = XMLUtils.createSAXParserFactory();
                SAXParser parser = saxParserFactory.newSAXParser();
                XCASDeserializer xcasDeserializer = new XCASDeserializer(this.main.getCas().getTypeSystem());
                this.main.getCas().reset();
                parser.parse(xcasFile, xcasDeserializer.getXCASHandler(this.main.getCas()));
                time.stop();
                this.main.handleSofas();
                this.main.setTitle("XCAS");
                this.main.updateIndexTree(true);
                this.main.setRunOnCasEnabled();
                this.main.setEnableCasFileReadingAndWriting();
                this.main.setStatusbarMessage("Done loading XCAS file in " + time.getTimeSpan() + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.main.handleException(e);
            }
        }
    }
}

