/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm;

public class CheckpointConfig {
    private String checkpointFile = "";
    private long frequency = -1L;
    private boolean timeBased = false;
    private boolean countBased = false;
    private boolean millis = false;
    private boolean seconds = false;
    private boolean minutes = false;

    public CheckpointConfig(String aChpFile, String aFrequency) {
        this.checkpointFile = aChpFile;
        this.determineFrequency(aFrequency);
    }

    private void determineFrequency(String aFrequency) {
        try {
            this.frequency = Long.parseLong(aFrequency);
            this.countBased = true;
        }
        catch (NumberFormatException nfe) {
            String number = "";
            String unit = "";
            for (int i = 0; i < aFrequency.length(); ++i) {
                if (Character.isDigit(aFrequency.charAt(i))) {
                    number = number + aFrequency.charAt(i);
                    continue;
                }
                unit = unit + aFrequency.charAt(i);
            }
            if (unit.toLowerCase().equals("m")) {
                this.minutes = true;
            } else if (unit.toLowerCase().equals("ms")) {
                this.millis = true;
            } else if (unit.toLowerCase().equals("s")) {
                this.seconds = true;
            }
            this.frequency = Long.parseLong(number);
            this.timeBased = true;
        }
    }

    public boolean isCountBased() {
        return this.countBased;
    }

    public long getFrequency() {
        return this.frequency;
    }

    public boolean isMillis() {
        return this.millis;
    }

    public boolean isMinutes() {
        return this.minutes;
    }

    public boolean isSeconds() {
        return this.seconds;
    }

    public boolean isTimeBased() {
        return this.timeBased;
    }

    public String getCheckpointFile() {
        return this.checkpointFile;
    }
}

