/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import org.apache.uima.internal.util.Common_hash_support;
import org.apache.uima.internal.util.IntKeyValueIterator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.util.IntEntry;
import org.apache.uima.util.impl.Constants;

public class Int2ObjHashMap<T, E extends T>
extends Common_hash_support
implements Iterable<IntEntry<E>> {
    private static final int REMOVED_KEY = Integer.MIN_VALUE;
    private int[] keys;
    private T[] values;
    private final Class<T> componentType;

    public Int2ObjHashMap(Class<T> clazz) {
        this(clazz, 10);
    }

    public Int2ObjHashMap(Class<T> clazz, int initialSizeBeforeExpanding) {
        super(initialSizeBeforeExpanding);
        this.componentType = clazz;
        this.newTable(this.initialCapacity);
    }

    private Int2ObjHashMap(Int2ObjHashMap orig) {
        super(orig);
        this.componentType = orig.componentType;
        this.keys = Arrays.copyOf(orig.keys, this.keys.length);
        this.values = Arrays.copyOf(orig.values, this.values.length);
    }

    private int findPosition(int key) {
        if (key == 0) {
            throw new IllegalArgumentException("0 is an invalid key");
        }
        if (key == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Integer.MIN_VALUE is an invalid key");
        }
        return this.findPosition(Misc.hashInt(key), i -> this.keys[i] == 0 || this.keys[i] == key, i -> this.keys[i] == Integer.MIN_VALUE);
    }

    public E get(int key) {
        return key == 0 ? null : (E)this.values[this.findPosition(key)];
    }

    public E remove(int key) {
        int pos = this.findPosition(key);
        T v = this.values[pos];
        int k = this.keys[pos];
        if (k != 0) {
            this.values[pos] = null;
            this.keys[pos] = Integer.MIN_VALUE;
            this.commonRemove();
        }
        return (E)v;
    }

    @Override
    protected void copy_to_new_table(int newCapacity, int oldCapacity, Common_hash_support.CommonCopyOld2New commonCopy) {
        int[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        commonCopy.apply(i -> this.putInner(oldKeys[i], oldValues[i]), i -> oldKeys[i] != 0 && oldKeys[i] != Integer.MIN_VALUE);
    }

    public boolean containsKey(int key) {
        int probeAddr = this.findPosition(key);
        return this.keys[probeAddr] != 0;
    }

    public T put(int key, T value) {
        int i = this.findPosition(key);
        boolean keyNotFound = this.keys[i] == 0;
        T prevValue = this.values[i];
        if (!keyNotFound) {
            this.values[i] = value;
            return prevValue;
        }
        if (this.found_removed != -1) {
            i = this.found_removed;
        }
        this.keys[i] = key;
        this.values[i] = value;
        this.commonPutOrAddNotFound();
        return prevValue;
    }

    public T computeIfAbsent(int key, IntFunction<T> mappingFunction) {
        int i = this.findPosition(key);
        if (this.keys[i] == 0) {
            if (this.found_removed != -1) {
                i = this.found_removed;
            }
            this.keys[i] = key;
            this.values[i] = mappingFunction.apply(key);
            this.commonPutOrAddNotFound();
            return this.values[i];
        }
        return this.values[i];
    }

    public T putIfAbsent(int key, T value) {
        int i = this.findPosition(key);
        if (this.keys[i] == 0) {
            if (this.found_removed != -1) {
                i = this.found_removed;
            }
            this.keys[i] = key;
            this.values[i] = value;
            this.commonPutOrAddNotFound();
            return value;
        }
        return this.values[i];
    }

    public void putInner(int key, T value) {
        int i = this.findPosition(key);
        assert (this.keys[i] == 0);
        this.keys[i] = key;
        this.values[i] = value;
    }

    public int[] getSortedKeys() {
        int size = this.size();
        if (size == 0) {
            return Constants.EMPTY_INT_ARRAY;
        }
        int[] r = new int[size];
        int i = 0;
        for (int k : this.keys) {
            if (k == 0 || k == Integer.MIN_VALUE) continue;
            r[i++] = k;
        }
        assert (i == this.size());
        Arrays.sort(r);
        return r;
    }

    public IntListIterator keyIterator() {
        return new KeyIterator();
    }

    public IntListIterator keyIterator(int aKey) {
        throw new UnsupportedOperationException();
    }

    public IntKeyValueIterator keyValueIterator(int aKey) {
        throw new UnsupportedOperationException();
    }

    public Iterator<E> values() {
        return new Iterator<E>(){
            private int curPosition;
            {
                this.curPosition = Int2ObjHashMap.this.moveToNextFilled(0);
            }

            @Override
            public boolean hasNext() {
                return this.curPosition < Int2ObjHashMap.this.keys.length;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object r = Int2ObjHashMap.this.values[this.curPosition];
                this.curPosition = Int2ObjHashMap.this.moveToNextFilled(this.curPosition + 1);
                return r;
            }
        };
    }

    public T[] valuesArray() {
        Iterator<E> it = this.values();
        int size = this.size();
        Object[] r = (Object[])Array.newInstance(this.componentType, size);
        for (int i = 0; i < size; ++i) {
            r[i] = it.next();
        }
        return r;
    }

    public Int2ObjHashMap<T, E> copy() {
        return new Int2ObjHashMap<T, E>(this);
    }

    @Override
    public Iterator<IntEntry<E>> iterator() {
        return new Iterator<IntEntry<E>>(){
            private int curPosition;
            {
                this.curPosition = Int2ObjHashMap.this.moveToNextFilled(0);
            }

            @Override
            public boolean hasNext() {
                return this.curPosition < Int2ObjHashMap.this.keys.length;
            }

            @Override
            public IntEntry<E> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                IntEntry<Object> r = new IntEntry<Object>(Int2ObjHashMap.this.keys[this.curPosition], Int2ObjHashMap.this.values[this.curPosition]);
                this.curPosition = Int2ObjHashMap.this.moveToNextFilled(this.curPosition + 1);
                return r;
            }
        };
    }

    @Override
    protected int keys_length() {
        return this.keys.length;
    }

    @Override
    protected boolean is_valid_key(int pos) {
        return this.keys[pos] != 0 && this.keys[pos] != Integer.MIN_VALUE;
    }

    @Override
    protected void newKeysAndValues(int size) {
        this.keys = new int[size];
        this.values = (Object[])Array.newInstance(this.componentType, size);
    }

    @Override
    protected void clearKeysAndValues() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
    }

    private class KeyIterator
    extends Common_hash_support.CommonKeyIterator
    implements IntListIterator {
        private KeyIterator() {
        }

        @Override
        public final int nextNvc() {
            int r = Int2ObjHashMap.this.keys[this.curPosition];
            this.curPosition = Int2ObjHashMap.this.moveToNextFilled(this.curPosition + 1);
            return r;
        }

        @Override
        public int previousNvc() {
            this.curPosition = Int2ObjHashMap.this.moveToPreviousFilled(this.curPosition - 1);
            return Int2ObjHashMap.this.keys[this.curPosition];
        }
    }
}

