/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.cli.SpecificationProperties;

public class Reason {
    private static final DuccLogger logger = DuccLogger.getLogger(Reason.class);
    private String user = null;
    private String role = null;
    private String message = null;

    public Reason(DuccId duccId, String user, String role, String message) {
        String methodName = "Reason";
        this.setUser(user);
        this.setRole(role);
        this.setMessage(message);
        logger.info(methodName, duccId, new Object[]{"user:" + user + " role:" + role + " message:" + message});
    }

    private String normalize(String value) {
        int start;
        String retVal = value;
        if (value != null && (retVal = retVal.trim()).startsWith("\"") && (retVal = retVal.substring(start = 1)).endsWith("\"")) {
            start = 0;
            int end = retVal.length() - 1;
            retVal = retVal.substring(start, end);
        }
        return retVal;
    }

    private void setUser(String value) {
        this.user = this.normalize(value);
    }

    private void setRole(String value) {
        this.role = this.normalize(value);
    }

    private void setMessage(String value) {
        this.message = this.normalize(value);
    }

    private boolean isRoleAdministrator() {
        boolean retVal = false;
        if (this.role != null && this.role.equals(SpecificationProperties.key_role_administrator)) {
            retVal = true;
        }
        return retVal;
    }

    public String toString() {
        String retVal;
        StringBuffer sb = new StringBuffer();
        if (this.isRoleAdministrator()) {
            if (this.user != null) {
                sb.append("Canceled by " + this.user);
                if (this.message != null) {
                    sb.append(" : ");
                    sb.append(this.message);
                }
            } else if (this.message != null) {
                sb.append(this.message);
            }
        } else if (this.message != null) {
            sb.append(this.message);
        }
        if ((retVal = sb.toString()).length() > 0) {
            retVal = "\"" + retVal + "\"";
        }
        return retVal;
    }
}

