/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event.jd;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.container.common.logger.IComponent;
import org.apache.uima.ducc.container.common.logger.Logger;
import org.apache.uima.ducc.transport.event.common.DuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.common.IDuccProcessWorkItems;
import org.apache.uima.ducc.transport.event.jd.IDuccProcessWorkItemsReport;

public class DuccProcessWorkItemsReport
implements IDuccProcessWorkItemsReport {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(DuccProcessWorkItemsReport.class, (String)IComponent.Id.JD.name());
    private ConcurrentHashMap<DuccId, IDuccProcessWorkItems> map = new ConcurrentHashMap();
    private IDuccProcessWorkItems totals = new DuccProcessWorkItems();

    @Override
    public ConcurrentHashMap<DuccId, IDuccProcessWorkItems> getMap() {
        return this.map;
    }

    @Override
    public IDuccProcessWorkItems getTotals() {
        return this.totals;
    }

    @Override
    public void accum(DuccId key, IDuccProcessWorkItems value) {
        String location = "accum";
        long dispatch = this.totals.getCountDispatch();
        long done = this.totals.getCountDone();
        long error = this.totals.getCountError();
        long preempt = this.totals.getCountPreempt();
        long retry = this.totals.getCountRetry();
        long newDispatch = dispatch + value.getCountDispatch();
        this.totals.setCountDispatch(newDispatch);
        long newDone = done + value.getCountDone();
        this.totals.setCountDone(newDone);
        long newError = error + value.getCountError();
        this.totals.setCountError(newError);
        long newPreempt = preempt + value.getCountPreempt();
        this.totals.setCountPreempt(newPreempt);
        long newRetry = retry + value.getCountRetry();
        this.totals.setCountRetry(newRetry);
        if (value.getCountDone() > 0L) {
            long cnt1 = this.totals.getCountDone();
            long avg1 = this.totals.getMillisAvg();
            long cnt2 = value.getCountDone();
            long avg2 = value.getMillisAvg();
            double top = avg1 * cnt1 + avg2 * cnt2;
            double bot = cnt1 + cnt2;
            long avg = (long)(top / bot);
            this.totals.setMillisAvg(avg);
            long max = this.totals.getMillisMax();
            long maxCandidate = value.getMillisMax();
            logger.trace(location, null, new Object[]{"max=" + max + " maxCandidate=" + maxCandidate});
            if (max > 0L) {
                if (maxCandidate > 0L && maxCandidate > max) {
                    max = maxCandidate;
                }
            } else {
                max = maxCandidate;
            }
            this.totals.setMillisMax(max);
            long min = this.totals.getMillisMin();
            long minCandidate = value.getMillisMin();
            logger.trace(location, null, new Object[]{"min=" + min + " minCandidate=" + minCandidate});
            if (min > 0L) {
                if (minCandidate > 0L && minCandidate < min) {
                    min = minCandidate;
                }
            } else {
                min = minCandidate;
            }
            this.totals.setMillisMin(min);
        }
        this.map.put(key, value);
    }
}

