/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.sd.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.ps.sd.task.SimpleTask;
import org.apache.uima.ducc.ps.sd.task.iface.ITask;
import org.apache.uima.ducc.ps.sd.task.iface.TaskAllocatorCallbackListener;
import org.apache.uima.ducc.ps.sd.task.iface.TaskConsumer;
import org.apache.uima.ducc.ps.service.utils.UimaSerializer;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.TypeSystemDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class TestTaskAllocatorCallbackListener
implements TaskAllocatorCallbackListener {
    Logger logger = UIMAFramework.getLogger(TestTaskAllocatorCallbackListener.class);
    private static UimaSerializer uimaSerializer = new UimaSerializer();
    private AtomicLong seqno = new AtomicLong(0L);
    private BufferedReader inf;
    private String text = "Some Text";

    public TestTaskAllocatorCallbackListener() throws FileNotFoundException {
        String taskFilename = System.getProperty("TestTaskFile");
        if (taskFilename != null) {
            File taskFile = new File(taskFilename);
            this.inf = new BufferedReader(new FileReader(taskFile));
        }
    }

    private String serialize(CAS cas) throws Exception {
        String serializedCas = uimaSerializer.serializeCasToXmi(cas);
        return serializedCas;
    }

    @Override
    public ITask getTask(TaskConsumer taskConsumer) {
        this.logger.log(Level.INFO, "getSerializedCAS() Call " + this.seqno.incrementAndGet() + " - from " + taskConsumer.getType() + ":" + taskConsumer.getHostName() + "-" + taskConsumer.getPid() + "-" + taskConsumer.getThreadId());
        String serializedCas = null;
        try {
            CAS cas = null;
            cas = CasCreationUtils.createCas((TypeSystemDescription)new TypeSystemDescription_impl(), null, null);
            cas.setDocumentLanguage("en");
            if (this.inf != null) {
                this.text = this.inf.readLine();
                if (this.text == null) {
                    this.inf.close();
                    this.inf = null;
                }
            }
            if (this.text == null) {
                this.logger.log(Level.INFO, " ... no work avaialble");
                return null;
            }
            this.logger.log(Level.INFO, "delivering: " + this.text);
            cas.setDocumentText(this.text);
            serializedCas = this.serialize(cas);
            cas.reset();
            cas.release();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error", (Throwable)e);
        }
        return new SimpleTask(serializedCas);
    }

    @Override
    public synchronized void onTaskSuccess(TaskConsumer taskConsumer, String appdata, String processResult) {
        this.logger.log(Level.INFO, "onTaskSuccess() Starting");
        System.out.println("----------appdata: " + appdata);
        this.logger.log(Level.INFO, "onTaskSuccess() Completed");
    }

    @Override
    public void onTaskFailure(TaskConsumer taskConsumer, String appdata, String processError) {
        this.logger.log(Level.INFO, "onTaskFailure) Called");
    }
}

