/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public class ServiceThreadFactory
implements ThreadFactory {
    private static final String THREAD_POOL = "[ServiceThreadPool ";
    private boolean isDaemon = false;
    private String threadNamePrefix = null;
    public static AtomicInteger poolIdGenerator = new AtomicInteger(1);

    @Override
    public Thread newThread(final Runnable r) {
        Thread newThread = null;
        try {
            newThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (ServiceThreadFactory.this.threadNamePrefix == null) {
                        ServiceThreadFactory.this.threadNamePrefix = ServiceThreadFactory.THREAD_POOL + poolIdGenerator + "]  Process Thread";
                    }
                    Thread.currentThread().setName(ServiceThreadFactory.this.threadNamePrefix + " - " + Thread.currentThread().getId());
                    r.run();
                    UIMAFramework.getLogger().log(Level.INFO, "Thread " + Thread.currentThread().getName() + " [" + Thread.currentThread().getId() + "] Terminating");
                }
            });
        }
        catch (Exception e) {
            UIMAFramework.getLogger().log(Level.WARNING, "", (Throwable)e);
        }
        newThread.setDaemon(this.isDaemon);
        return newThread;
    }
}

